/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.serialization;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.InternalDataSerializer;

public class EnumSerializer
extends DataSerializer
implements Serializable {
    private static final long serialVersionUID = -7069461993489626976L;
    private static final ConcurrentMap<Class<?>, Enum[]> supportedEnumTypes = new ConcurrentHashMap();
    private int id = 1024;

    public boolean toData(Object obj, DataOutput out) throws IOException {
        return obj instanceof Enum && this.serialize((Enum)obj, out);
    }

    private boolean serialize(Enum<?> enumeratedValue, DataOutput out) throws IOException {
        DataSerializer.writeClass(this.registerEnumType(enumeratedValue), (DataOutput)out);
        out.writeInt(enumeratedValue.ordinal());
        return true;
    }

    private Class<?> registerEnumType(Enum<?> enumeratedValue) {
        return this.addEnum(enumeratedValue.getDeclaringClass());
    }

    public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
        Class type = DataSerializer.readClass((DataInput)in);
        return Optional.ofNullable(type).filter(Class::isEnum).map(enumType -> {
            int ordinal = this.safeReadInt(in);
            return ((Enum[])supportedEnumTypes.get(this.addEnum((Class<?>)enumType)))[ordinal];
        }).orElseThrow(() -> new IOException(String.format("Non-enum type [%s] read from the stream", type)));
    }

    private int safeReadInt(DataInput in) {
        try {
            return in.readInt();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read int from DataInput", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> addEnum(Class<?> enumType) {
        ConcurrentMap<Class<?>, Enum[]> concurrentMap = supportedEnumTypes;
        synchronized (concurrentMap) {
            if (!supportedEnumTypes.containsKey(enumType)) {
                supportedEnumTypes.put(enumType, (Enum[])enumType.getEnumConstants());
                this.potentiallyReRegisterThisSerializer();
            }
        }
        return enumType;
    }

    private void potentiallyReRegisterThisSerializer() {
        if (InternalDataSerializer.getSerializer((int)this.getId()) != null) {
            InternalDataSerializer.unregister((int)this.getId());
            DataSerializer.register(this.getClass());
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Class<?>[] getSupportedClasses() {
        return supportedEnumTypes.keySet().toArray(new Class[supportedEnumTypes.size()]);
    }
}

