/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.apache.geode.pdx.PdxSerializer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.EnablePdx;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.support.PdxDiskStoreAwareBeanFactoryPostProcessor;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.MappingPdxSerializer;
import org.springframework.data.gemfire.support.NoOpBeanFactoryPostProcessor;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

@Configuration(value="PdxConfiguration")
public class PdxConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    public static final boolean DEFAULT_IGNORE_UNREAD_FIELDS = false;
    public static final boolean DEFAULT_PERSISTENT = false;
    public static final boolean DEFAULT_READ_SERIALIZED = false;
    public static final String DEFAULT_PDX_DISK_STORE_NAME = "";
    public static final String DEFAULT_PDX_SERIALIZER_BEAN_NAME = "";
    private Boolean ignoreUnreadFields;
    private Boolean persistent;
    private Boolean readSerialized;
    private String diskStoreName;
    private String serializerBeanName;

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnablePdx.class;
    }

    @Override
    protected BeanFactory getBeanFactory() {
        return super.getBeanFactory();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enablePdxAttributes = this.getAnnotationAttributes(importMetadata);
            this.setDiskStoreName(this.resolveProperty(this.pdxProperty("disk-store-name"), enablePdxAttributes.containsKey((Object)"diskStoreName") ? enablePdxAttributes.getString("diskStoreName") : null));
            this.setIgnoreUnreadFields(this.resolveProperty(this.pdxProperty("ignore-unread-fields"), enablePdxAttributes.containsKey((Object)"ignoreUnreadFields") ? enablePdxAttributes.getBoolean("ignoreUnreadFields") : false));
            this.setPersistent(this.resolveProperty(this.pdxProperty("persistent"), enablePdxAttributes.containsKey((Object)"persistent") ? Boolean.valueOf(enablePdxAttributes.getBoolean("persistent")) : null));
            this.setReadSerialized(this.resolveProperty(this.pdxProperty("read-serialized"), enablePdxAttributes.containsKey((Object)"readSerialized") ? Boolean.valueOf(enablePdxAttributes.getBoolean("readSerialized")) : null));
            this.setSerializerBeanName(this.resolveProperty(this.pdxProperty("serializer-bean-name"), enablePdxAttributes.containsKey((Object)"serializerBeanName") ? enablePdxAttributes.getString("serializerBeanName") : null));
        }
    }

    void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    protected Optional<String> getDiskStoreName() {
        return Optional.ofNullable(this.diskStoreName).filter(StringUtils::hasText);
    }

    void setIgnoreUnreadFields(Boolean ignoreUnreadFields) {
        this.ignoreUnreadFields = ignoreUnreadFields;
    }

    protected boolean isIgnoreUnreadFields() {
        return Boolean.TRUE.equals(this.ignoreUnreadFields);
    }

    void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    void setReadSerialized(Boolean readSerialized) {
        this.readSerialized = readSerialized;
    }

    protected boolean isReadSerialized() {
        return Boolean.TRUE.equals(this.readSerialized);
    }

    void setSerializerBeanName(String serializerBeanName) {
        this.serializerBeanName = serializerBeanName;
    }

    protected Optional<String> getSerializerBeanName() {
        return Optional.ofNullable(this.serializerBeanName).filter(StringUtils::hasText);
    }

    @Bean
    BeanFactoryPostProcessor pdxDiskStoreAwareBeanFactoryPostProcessor() {
        return this.getDiskStoreName().map(PdxDiskStoreAwareBeanFactoryPostProcessor::new).orElse(NoOpBeanFactoryPostProcessor.INSTANCE);
    }

    @Bean
    ClientCacheConfigurer clientCachePdxConfigurer() {
        return (beanName, clientCacheFactoryBean) -> this.configurePdx(clientCacheFactoryBean);
    }

    @Bean
    PeerCacheConfigurer peerCachePdxConfigurer() {
        return (beanName, cacheFactoryBean) -> this.configurePdx(cacheFactoryBean);
    }

    protected void configurePdx(CacheFactoryBean cacheFactoryBean) {
        this.getDiskStoreName().ifPresent(cacheFactoryBean::setPdxDiskStoreName);
        cacheFactoryBean.setPdxIgnoreUnreadFields(this.isIgnoreUnreadFields());
        cacheFactoryBean.setPdxPersistent(this.isPersistent());
        cacheFactoryBean.setPdxReadSerialized(this.isReadSerialized());
        cacheFactoryBean.setPdxSerializer(this.resolvePdxSerializer());
    }

    protected Optional<ConversionService> resolveConversionService() {
        return Optional.of(this.getBeanFactory()).filter(it -> it instanceof ConfigurableBeanFactory).map(it -> ((ConfigurableBeanFactory)it).getConversionService());
    }

    protected Optional<GemfireMappingContext> resolveMappingContext() {
        try {
            return Optional.of(this.getBeanFactory().getBean(GemfireMappingContext.class));
        }
        catch (Throwable ignore) {
            return Optional.empty();
        }
    }

    @NonNull
    protected PdxSerializer resolvePdxSerializer() {
        BeanFactory beanFactory = this.getBeanFactory();
        return this.getSerializerBeanName().filter(arg_0 -> ((BeanFactory)beanFactory).containsBean(arg_0)).map(beanName -> (PdxSerializer)beanFactory.getBean(beanName, PdxSerializer.class)).orElseGet(this::newPdxSerializer);
    }

    @NonNull
    protected <T extends PdxSerializer> T newPdxSerializer() {
        return (T)MappingPdxSerializer.create(this.resolveMappingContext().orElse(null), this.resolveConversionService().orElse(null));
    }
}

