/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableCachingDefinedRegions;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.annotation.support.CacheTypeAwareRegionFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration
public class CachingDefinedRegionsConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    private final CacheNameResolver composableCacheNameResolver = type -> Arrays.asList(new Jsr107CacheAnnotationsCacheNameResolver(), new SpringCacheAnnotationsCacheNameResolver()).stream().flatMap(cacheNameResolver -> cacheNameResolver.resolveCacheNames(type).stream()).collect(Collectors.toSet());
    private ClientRegionShortcut clientRegionShortcut = ClientRegionShortcut.PROXY;
    @Autowired(required=false)
    private List<RegionConfigurer> regionConfigurers = Collections.emptyList();
    private RegionShortcut serverRegionShortcut = RegionShortcut.PARTITION;
    private String poolName = "DEFAULT";

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableCachingDefinedRegions.class;
    }

    protected CacheNameResolver getCacheNameResolver() {
        return this.composableCacheNameResolver;
    }

    public void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        this.clientRegionShortcut = clientRegionShortcut;
    }

    protected Optional<ClientRegionShortcut> getClientRegionShortcut() {
        return Optional.ofNullable(this.clientRegionShortcut);
    }

    protected ClientRegionShortcut resolveClientRegionShortcut() {
        return this.getClientRegionShortcut().orElse(ClientRegionShortcut.PROXY);
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    protected Optional<String> getPoolName() {
        return Optional.ofNullable(this.poolName).filter(StringUtils::hasText);
    }

    protected String resolvePoolName() {
        return this.getPoolName().orElse("DEFAULT");
    }

    public void setServerRegionShortcut(RegionShortcut serverRegionShortcut) {
        this.serverRegionShortcut = serverRegionShortcut;
    }

    protected Optional<RegionShortcut> getServerRegionShortcut() {
        return Optional.ofNullable(this.serverRegionShortcut);
    }

    protected RegionShortcut resolveServerRegionShortcut() {
        return this.getServerRegionShortcut().orElse(RegionShortcut.PARTITION);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enableCachingDefinedRegionsAttributes = this.getAnnotationAttributes(importMetadata);
            this.setClientRegionShortcut((ClientRegionShortcut)enableCachingDefinedRegionsAttributes.getEnum("clientRegionShortcut"));
            this.setPoolName(enableCachingDefinedRegionsAttributes.getString("poolName"));
            this.setServerRegionShortcut((RegionShortcut)enableCachingDefinedRegionsAttributes.getEnum("serverRegionShortcut"));
        }
    }

    @Bean
    public BeanPostProcessor cachingAnnotationsRegionBeanRegistrar(final ConfigurableBeanFactory beanFactory) {
        return new BeanPostProcessor(){

            @Nullable
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (CachingDefinedRegionsConfiguration.this.isNotInfrastructureBean(bean)) {
                    CachingDefinedRegionsConfiguration.this.registerRegionBeans(CachingDefinedRegionsConfiguration.this.getCacheNameResolver().resolveCacheNames(bean.getClass()), beanFactory);
                }
                return bean;
            }
        };
    }

    private ConfigurableBeanFactory registerRegionBeans(Set<String> cacheNames, ConfigurableBeanFactory beanFactory) {
        cacheNames.forEach(cacheName -> {
            if (!beanFactory.containsBean(cacheName)) {
                try {
                    CacheTypeAwareRegionFactoryBean regionFactoryBean = new CacheTypeAwareRegionFactoryBean();
                    GemFireCache gemfireCache = (GemFireCache)beanFactory.getBean(GemFireCache.class);
                    regionFactoryBean.setCache(gemfireCache);
                    regionFactoryBean.setClientRegionShortcut(this.resolveClientRegionShortcut());
                    regionFactoryBean.setRegionConfigurers(this.resolveRegionConfigurers());
                    regionFactoryBean.setRegionName((String)cacheName);
                    regionFactoryBean.setServerRegionShortcut(this.resolveServerRegionShortcut());
                    String poolName = this.resolvePoolName();
                    if (!"DEFAULT".equalsIgnoreCase(poolName)) {
                        regionFactoryBean.setPoolName(poolName);
                    }
                    regionFactoryBean.afterPropertiesSet();
                    Optional.ofNullable(regionFactoryBean.getObject()).ifPresent(region -> beanFactory.registerSingleton(cacheName, region));
                }
                catch (Exception cause) {
                    throw new BeanInstantiationException(Region.class, String.format("Failed to create Region for cache [%s]", cacheName), (Throwable)cause);
                }
            }
        });
        return beanFactory;
    }

    protected List<RegionConfigurer> resolveRegionConfigurers() {
        return Optional.ofNullable(this.regionConfigurers).filter(regionConfigurers -> !regionConfigurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(RegionConfigurer.class, true, false);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    protected class SpringCacheAnnotationsCacheNameResolver
    extends AbstractCacheNameResolver {
        protected SpringCacheAnnotationsCacheNameResolver() {
        }

        @Override
        protected Class<? extends Annotation>[] getClassCacheAnnotationTypes() {
            return this.append(this.getMethodCacheAnnotationTypes(), Caching.class);
        }

        @Override
        protected Class<? extends Annotation>[] getMethodCacheAnnotationTypes() {
            return ArrayUtils.asArray(Cacheable.class, CacheEvict.class, org.springframework.cache.annotation.CachePut.class);
        }

        @Override
        public Set<String> resolveCacheNames(Class<?> type) {
            Set<String> cacheNames = super.resolveCacheNames(type);
            cacheNames.addAll(this.resolveCachingCacheNames(type));
            Arrays.stream(type.getMethods()).filter(method -> CachingDefinedRegionsConfiguration.this.isUserLevelMethod(method)).forEach(method -> cacheNames.addAll(this.resolveCachingCacheNames((AnnotatedElement)method)));
            return cacheNames;
        }

        private Set<String> resolveCachingCacheNames(AnnotatedElement annotatedElement) {
            HashSet<String> cacheNames = new HashSet<String>();
            Optional.ofNullable(CachingDefinedRegionsConfiguration.this.resolveAnnotation(annotatedElement, Caching.class)).ifPresent(caching -> StreamUtils.concat(Arrays.stream(caching.cacheable()), Arrays.stream(caching.evict()), Arrays.stream(caching.put())).flatMap(cacheAnnotation -> this.resolveCacheNames((Annotation)cacheAnnotation).stream()).collect(Collectors.toCollection(() -> cacheNames)));
            return cacheNames;
        }
    }

    protected class Jsr107CacheAnnotationsCacheNameResolver
    extends AbstractCacheNameResolver {
        protected Jsr107CacheAnnotationsCacheNameResolver() {
        }

        @Override
        protected Class<? extends Annotation>[] getClassCacheAnnotationTypes() {
            return this.append(this.getMethodCacheAnnotationTypes(), CacheDefaults.class);
        }

        @Override
        protected Class<? extends Annotation>[] getMethodCacheAnnotationTypes() {
            return ArrayUtils.asArray(CachePut.class, CacheRemove.class, CacheRemoveAll.class, CacheResult.class);
        }
    }

    protected abstract class AbstractCacheNameResolver
    implements CacheNameResolver {
        private final String JSR_107_CACHE_NAME_ATTRIBUTE_NAME = "cacheName";
        private final String SPRING_CACHE_NAMES_ATTRIBUTE_NAME = "cacheNames";
        private final String[] EMPTY_ARRAY = new String[0];

        protected AbstractCacheNameResolver() {
        }

        protected abstract Class<? extends Annotation>[] getClassCacheAnnotationTypes();

        protected abstract Class<? extends Annotation>[] getMethodCacheAnnotationTypes();

        protected Class[] append(Class[] annotationTypes, Class ... additionalAnnotationTypes) {
            ArrayList<Class> annotationTypeList = new ArrayList<Class>(Arrays.asList(annotationTypes));
            Collections.addAll(annotationTypeList, additionalAnnotationTypes);
            return annotationTypeList.toArray(new Class[annotationTypeList.size()]);
        }

        protected Set<String> resolveCacheNames(Annotation annotation) {
            return Optional.ofNullable(annotation).map(it -> CachingDefinedRegionsConfiguration.this.getAnnotationAttributes(it)).map(annotationAttributes -> {
                String attributeName = annotationAttributes.containsKey((Object)"cacheNames") ? "cacheNames" : "cacheName";
                return annotationAttributes.containsKey((Object)attributeName) ? annotationAttributes.getStringArray(attributeName) : this.EMPTY_ARRAY;
            }).map(CollectionUtils::asSet).orElse(Collections.emptySet());
        }

        @Override
        public Set<String> resolveCacheNames(Class<?> type) {
            HashSet<String> cacheNames = new HashSet<String>();
            cacheNames.addAll(this.resolveCacheNames(type, this.getClassCacheAnnotationTypes()));
            Arrays.stream(type.getMethods()).filter(method -> CachingDefinedRegionsConfiguration.this.isUserLevelMethod(method)).forEach(method -> cacheNames.addAll(this.resolveCacheNames((AnnotatedElement)method, this.getMethodCacheAnnotationTypes())));
            return cacheNames;
        }

        protected Set<String> resolveCacheNames(AnnotatedElement annotatedElement, Class<? extends Annotation> ... annotationTypes) {
            Stream cacheNames = Arrays.stream(ArrayUtils.nullSafeArray(annotationTypes, Class.class)).map(annotationType -> CachingDefinedRegionsConfiguration.this.resolveAnnotation(annotatedElement, annotationType)).flatMap(annotation -> this.resolveCacheNames((Annotation)annotation).stream());
            return cacheNames.collect(Collectors.toSet());
        }
    }

    @FunctionalInterface
    protected static interface CacheNameResolver {
        public Set<String> resolveCacheNames(Class<?> var1);
    }
}

