/*
 * Copyright 2017-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.data.gemfire.config.annotation;

import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;

/**
 * The {@link ContinuousQueryListenerContainerConfigurer} interfaces defines a contract for implementations to customize
 * the configuration of SDG's {@link ContinuousQueryListenerContainer} when enabling Continuous Query (CQ) functionality
 * in Spring Boot, Pivotal GemFire/Apache Geode cache client applications.
 *
 * @author John Blum
 * @see org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer
 * @since 2.0.0
 */
public interface ContinuousQueryListenerContainerConfigurer {

	/**
	 * Applies addditional configuration to the declared/defined {@link ContinuousQueryListenerContainer}.
	 *
	 * @param beanName {@link String name} of the {@link ContinuousQueryListenerContainer} bean definition.
	 * @param container reference to the {@link ContinuousQueryListenerContainer} instance.
	 * @see org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer
	 */
	void configure(String beanName, ContinuousQueryListenerContainer container);

}
