/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.text.MessageFormat;

public abstract class RuntimeExceptionFactory {
    public static final String NOT_IMPLEMENTED = "Not Implemented";
    public static final String NOT_SUPPORTED = "Operation Not Supported";

    public static IllegalArgumentException newIllegalArgumentException(String message, Object ... args) {
        return RuntimeExceptionFactory.newIllegalArgumentException(null, message, args);
    }

    public static IllegalArgumentException newIllegalArgumentException(Throwable cause, String message, Object ... args) {
        return new IllegalArgumentException(RuntimeExceptionFactory.format(message, args), cause);
    }

    public static IllegalStateException newIllegalStateException(String message, Object ... args) {
        return RuntimeExceptionFactory.newIllegalStateException(null, message, args);
    }

    public static IllegalStateException newIllegalStateException(Throwable cause, String message, Object ... args) {
        return new IllegalStateException(RuntimeExceptionFactory.format(message, args), cause);
    }

    public static RuntimeException newRuntimeException(String message, Object ... args) {
        return RuntimeExceptionFactory.newRuntimeException(null, message, args);
    }

    public static RuntimeException newRuntimeException(Throwable cause, String message, Object ... args) {
        return new RuntimeException(RuntimeExceptionFactory.format(message, args), cause);
    }

    public static UnsupportedOperationException newUnsupportedOperationException(String message, Object ... args) {
        return RuntimeExceptionFactory.newUnsupportedOperationException(null, message, args);
    }

    public static UnsupportedOperationException newUnsupportedOperationException(Throwable cause, String message, Object ... args) {
        return new UnsupportedOperationException(RuntimeExceptionFactory.format(message, args), cause);
    }

    protected static String format(String message, Object ... args) {
        return MessageFormat.format(String.format(message, args), args);
    }
}

