/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.management.internal.security.ResourcePermissions;
import org.apache.geode.security.ResourcePermission;
import org.springframework.data.gemfire.function.BatchingResultSender;
import org.springframework.data.gemfire.function.FunctionArgumentResolver;
import org.springframework.data.gemfire.function.FunctionContextInjectingArgumentResolver;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PojoFunctionWrapper
implements Function {
    private static transient Log logger = LogFactory.getLog(PojoFunctionWrapper.class);
    private volatile boolean HA;
    private volatile boolean hasResult;
    private volatile boolean optimizeForWrite;
    private volatile int batchSize;
    private Collection<ResourcePermission> requiredPermissions = CollectionUtils.asSet(ResourcePermissions.DATA_WRITE);
    private final FunctionArgumentResolver functionArgumentResolver;
    private final Method method;
    private final Object target;
    private final String id;

    public PojoFunctionWrapper(Object target, Method method) {
        this(target, method, null);
    }

    public PojoFunctionWrapper(Object target, Method method, String id) {
        this.target = target;
        this.method = method;
        this.id = this.resolveId(method, id);
        this.functionArgumentResolver = this.newFunctionArgumentResolver(method);
        this.HA = false;
        this.hasResult = this.resolveHasResult(method);
        this.optimizeForWrite = false;
    }

    protected FunctionArgumentResolver newFunctionArgumentResolver(Method method) {
        return new FunctionContextInjectingArgumentResolver(method);
    }

    protected boolean resolveHasResult(Method method) {
        return !method.getReturnType().equals(Void.TYPE);
    }

    protected String resolveId(Method method, String id) {
        return StringUtils.hasText((String)id) ? id : method.getName();
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setHA(boolean HA) {
        this.HA = HA;
    }

    public boolean isHA() {
        return this.HA;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public String getId() {
        return this.id;
    }

    public void setOptimizeForWrite(boolean optimizeForWrite) {
        this.optimizeForWrite = optimizeForWrite;
    }

    public boolean optimizeForWrite() {
        return this.optimizeForWrite;
    }

    public void setRequiredPermissions(Collection<ResourcePermission> requiredPermissions) {
        this.requiredPermissions = requiredPermissions;
    }

    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.unmodifiableCollection(this.requiredPermissions);
    }

    public void execute(FunctionContext functionContext) {
        Object[] args = this.functionArgumentResolver.resolveFunctionArguments(functionContext);
        Object result = this.invokeTargetMethod(args);
        if (this.hasResult()) {
            this.sendResults((ResultSender<Object>)functionContext.getResultSender(), result);
        }
    }

    protected final Object invokeTargetMethod(Object[] args) {
        if (logger.isDebugEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("About to invoke method [%s] on class [%s] as Function [%s]", this.method.getName(), this.target.getClass().getName(), this.getId()));
            }
            for (Object arg : args) {
                logger.debug((Object)String.format("Argument of type [%s] is [%s]", arg.getClass().getName(), arg.toString()));
            }
        }
        return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.target, (Object[])args);
    }

    private void sendResults(ResultSender<Object> resultSender, Object result) {
        if (result == null) {
            resultSender.lastResult(null);
        } else if (ObjectUtils.isArray((Object)result)) {
            new BatchingResultSender(this.batchSize, resultSender).sendArrayResults(result);
        } else if (Iterable.class.isAssignableFrom(result.getClass())) {
            new BatchingResultSender(this.batchSize, resultSender).sendResults((Iterable)result);
        } else {
            resultSender.lastResult(result);
        }
    }
}

