/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.CacheServerApplication;
import org.springframework.data.gemfire.config.annotation.ClientCacheApplication;
import org.springframework.data.gemfire.config.annotation.PeerCacheApplication;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.support.CustomEditorBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.support.DefinedIndexesApplicationListener;
import org.springframework.data.gemfire.config.support.DiskStoreDirectoryBeanPostProcessor;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.PropertiesBuilder;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractCacheConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    private static final AtomicBoolean CUSTOM_EDITORS_BEAN_FACTORY_POST_PROCESSOR_REGISTERED = new AtomicBoolean(false);
    private static final AtomicBoolean DEFINED_INDEXES_APPLICATION_LISTENER_REGISTERED = new AtomicBoolean(false);
    private static final AtomicBoolean DISK_STORE_DIRECTORY_BEAN_POST_PROCESSOR_REGISTERED = new AtomicBoolean(false);
    protected static final boolean DEFAULT_CLOSE = true;
    protected static final boolean DEFAULT_COPY_ON_READ = false;
    protected static final boolean DEFAULT_USE_BEAN_FACTORY_LOCATOR = false;
    protected static final int DEFAULT_MCAST_PORT = 0;
    protected static final String DEFAULT_LOCATORS = "";
    protected static final String DEFAULT_LOG_LEVEL = "config";
    protected static final String DEFAULT_NAME = "SpringDataGemFireApplication";
    private boolean close = true;
    private boolean copyOnRead = false;
    private boolean useBeanFactoryLocator = false;
    private CacheFactoryBean.DynamicRegionSupport dynamicRegionSupport;
    private Integer mcastPort = 0;
    private Float criticalHeapPercentage;
    private Float criticalOffHeapPercentage;
    private Float evictionHeapPercentage;
    private Float evictionOffHeapPercentage;
    private GatewayConflictResolver gatewayConflictResolver;
    private List<CacheFactoryBean.JndiDataSource> jndiDataSources;
    private List<TransactionListener> transactionListeners;
    private PropertiesBuilder customGemFireProperties = PropertiesBuilder.create();
    private Resource cacheXml;
    private String locators = "";
    private String logLevel = "config";
    private String name;
    private String startLocator;
    private TransactionWriter transactionWriter;

    @Bean
    protected Properties gemfireProperties() {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        gemfireProperties.setProperty("name", this.name());
        gemfireProperties.setProperty("mcast-port", this.mcastPort());
        gemfireProperties.setProperty("log-level", this.logLevel());
        gemfireProperties.setProperty("locators", this.locators());
        gemfireProperties.setProperty("start-locator", this.startLocator());
        gemfireProperties.add(this.customGemFireProperties);
        return gemfireProperties.build();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.configureInfrastructure(importMetadata);
        this.configureCache(importMetadata);
        this.configureOptional(importMetadata);
    }

    protected void configureInfrastructure(AnnotationMetadata importMetadata) {
        this.registerCustomEditorBeanFactoryPostProcessor(importMetadata);
        this.registerDefinedIndexesApplicationListener(importMetadata);
        this.registerDiskStoreDirectoryBeanPostProcessor(importMetadata);
    }

    private void registerCustomEditorBeanFactoryPostProcessor(AnnotationMetadata importMetadata) {
        if (CUSTOM_EDITORS_BEAN_FACTORY_POST_PROCESSOR_REGISTERED.compareAndSet(false, true)) {
            this.register(BeanDefinitionBuilder.rootBeanDefinition(CustomEditorBeanFactoryPostProcessor.class).setRole(2).getBeanDefinition());
        }
    }

    private void registerDefinedIndexesApplicationListener(AnnotationMetadata importMetadata) {
        if (DEFINED_INDEXES_APPLICATION_LISTENER_REGISTERED.compareAndSet(false, true)) {
            this.register(BeanDefinitionBuilder.rootBeanDefinition(DefinedIndexesApplicationListener.class).setRole(2).getBeanDefinition());
        }
    }

    private void registerDiskStoreDirectoryBeanPostProcessor(AnnotationMetadata importMetadata) {
        if (DISK_STORE_DIRECTORY_BEAN_POST_PROCESSOR_REGISTERED.compareAndSet(false, true)) {
            this.register(BeanDefinitionBuilder.rootBeanDefinition(DiskStoreDirectoryBeanPostProcessor.class).setRole(2).getBeanDefinition());
        }
    }

    protected void configureCache(AnnotationMetadata importMetadata) {
        if (this.isClientPeerOrServerCacheApplication(importMetadata)) {
            AnnotationAttributes cacheMetadataAttributes = this.getAnnotationAttributes(importMetadata);
            this.setCopyOnRead(this.resolveProperty(this.cacheProperty("copy-on-read"), Boolean.TRUE.equals(cacheMetadataAttributes.get((Object)"copyOnRead"))));
            Optional.ofNullable(this.resolveProperty(this.cacheProperty("critical-heap-percentage"), (Float)null)).ifPresent(this::setCriticalHeapPercentage);
            Optional.ofNullable((Float)cacheMetadataAttributes.get((Object)"criticalHeapPercentage")).filter(it -> this.getCriticalHeapPercentage() == null).filter(AbstractAnnotationConfigSupport::hasValue).ifPresent(this::setCriticalHeapPercentage);
            Optional.ofNullable(this.resolveProperty(this.cacheProperty("critical-off-heap-percentage"), (Float)null)).ifPresent(this::setCriticalOffHeapPercentage);
            Optional.ofNullable((Float)cacheMetadataAttributes.get((Object)"criticalOffHeapPercentage")).filter(it -> this.getCriticalOffHeapPercentage() == null).filter(AbstractAnnotationConfigSupport::hasValue).ifPresent(this::setCriticalOffHeapPercentage);
            Optional.ofNullable(this.resolveProperty(this.cacheProperty("eviction-heap-percentage"), (Float)null)).ifPresent(this::setEvictionHeapPercentage);
            Optional.ofNullable((Float)cacheMetadataAttributes.get((Object)"evictionHeapPercentage")).filter(it -> this.getEvictionHeapPercentage() == null).filter(AbstractAnnotationConfigSupport::hasValue).ifPresent(this::setEvictionHeapPercentage);
            Optional.ofNullable(this.resolveProperty(this.cacheProperty("eviction-off-heap-percentage"), (Float)null)).ifPresent(this::setEvictionOffHeapPercentage);
            Optional.ofNullable((Float)cacheMetadataAttributes.get((Object)"evictionOffHeapPercentage")).filter(it -> this.getEvictionOffHeapPercentage() == null).filter(AbstractAnnotationConfigSupport::hasValue).ifPresent(this::setEvictionOffHeapPercentage);
            this.setLogLevel(this.resolveProperty(this.cacheProperty("log-level"), (String)cacheMetadataAttributes.get((Object)"logLevel")));
            this.setName(this.resolveProperty(this.propertyName("name"), this.resolveProperty(this.cacheProperty("name"), (String)cacheMetadataAttributes.get((Object)"name"))));
            this.setUseBeanFactoryLocator(this.resolveProperty(this.propertyName("use-bean-factory-locator"), Boolean.TRUE.equals(cacheMetadataAttributes.get((Object)"useBeanFactoryLocator"))));
        }
    }

    protected void configureOptional(AnnotationMetadata importMetadata) {
    }

    protected <T extends CacheFactoryBean> T constructCacheFactoryBean() {
        return this.configureCacheFactoryBean(this.newCacheFactoryBean());
    }

    protected abstract <T extends CacheFactoryBean> T newCacheFactoryBean();

    protected <T extends CacheFactoryBean> T configureCacheFactoryBean(T gemfireCache) {
        gemfireCache.setBeanClassLoader(this.getBeanClassLoader());
        gemfireCache.setBeanFactory(this.getBeanFactory());
        gemfireCache.setCacheXml(this.getCacheXml());
        gemfireCache.setClose(this.isClose());
        gemfireCache.setCopyOnRead(this.getCopyOnRead());
        gemfireCache.setCriticalHeapPercentage(this.getCriticalHeapPercentage());
        gemfireCache.setCriticalOffHeapPercentage(this.getCriticalOffHeapPercentage());
        gemfireCache.setDynamicRegionSupport(this.getDynamicRegionSupport());
        gemfireCache.setEvictionHeapPercentage(this.getEvictionHeapPercentage());
        gemfireCache.setEvictionOffHeapPercentage(this.getEvictionOffHeapPercentage());
        gemfireCache.setGatewayConflictResolver(this.getGatewayConflictResolver());
        gemfireCache.setJndiDataSources(this.getJndiDataSources());
        gemfireCache.setProperties(this.gemfireProperties());
        gemfireCache.setTransactionListeners(this.getTransactionListeners());
        gemfireCache.setTransactionWriter(this.getTransactionWriter());
        gemfireCache.setUseBeanFactoryLocator(this.useBeanFactoryLocator());
        return gemfireCache;
    }

    protected boolean isCacheServerApplication(AnnotationMetadata importMetadata) {
        return this.isTypedCacheApplication(CacheServerApplication.class, importMetadata);
    }

    protected boolean isClientCacheApplication(AnnotationMetadata importMetadata) {
        return this.isTypedCacheApplication(ClientCacheApplication.class, importMetadata);
    }

    protected boolean isPeerCacheApplication(AnnotationMetadata importMetadata) {
        return this.isTypedCacheApplication(PeerCacheApplication.class, importMetadata);
    }

    protected boolean isTypedCacheApplication(Class<? extends Annotation> annotationType, AnnotationMetadata importMetadata) {
        return annotationType.equals(this.getAnnotationType()) && importMetadata.hasAnnotation(this.getAnnotationTypeName());
    }

    protected boolean isCacheServerOrPeerCacheApplication(AnnotationMetadata importMetadata) {
        return this.isCacheServerApplication(importMetadata) || this.isPeerCacheApplication(importMetadata);
    }

    protected boolean isClientPeerOrServerCacheApplication(AnnotationMetadata importMetadata) {
        return this.isCacheServerApplication(importMetadata) || this.isClientCacheApplication(importMetadata) || this.isPeerCacheApplication(importMetadata);
    }

    void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    protected Resource getCacheXml() {
        return this.cacheXml;
    }

    void setClose(boolean close) {
        this.close = close;
    }

    protected boolean isClose() {
        return this.close;
    }

    void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    protected boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    void setCriticalHeapPercentage(Float criticalHeapPercentage) {
        this.criticalHeapPercentage = criticalHeapPercentage;
    }

    protected Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    void setCriticalOffHeapPercentage(Float criticalOffHeapPercentage) {
        this.criticalOffHeapPercentage = criticalOffHeapPercentage;
    }

    protected Float getCriticalOffHeapPercentage() {
        return this.criticalOffHeapPercentage;
    }

    void setDynamicRegionSupport(CacheFactoryBean.DynamicRegionSupport dynamicRegionSupport) {
        this.dynamicRegionSupport = dynamicRegionSupport;
    }

    protected CacheFactoryBean.DynamicRegionSupport getDynamicRegionSupport() {
        return this.dynamicRegionSupport;
    }

    void setEvictionHeapPercentage(Float evictionHeapPercentage) {
        this.evictionHeapPercentage = evictionHeapPercentage;
    }

    protected Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    void setEvictionOffHeapPercentage(Float evictionOffHeapPercentage) {
        this.evictionOffHeapPercentage = evictionOffHeapPercentage;
    }

    protected Float getEvictionOffHeapPercentage() {
        return this.evictionOffHeapPercentage;
    }

    void setGatewayConflictResolver(GatewayConflictResolver gatewayConflictResolver) {
        this.gatewayConflictResolver = gatewayConflictResolver;
    }

    protected GatewayConflictResolver getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    void setJndiDataSources(List<CacheFactoryBean.JndiDataSource> jndiDataSources) {
        this.jndiDataSources = jndiDataSources;
    }

    protected List<CacheFactoryBean.JndiDataSource> getJndiDataSources() {
        return CollectionUtils.nullSafeList(this.jndiDataSources);
    }

    void setLocators(String locators) {
        this.locators = locators;
        this.mcastPort = 0;
    }

    protected String locators() {
        return this.locators;
    }

    void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    protected String logLevel() {
        return Optional.ofNullable(this.logLevel).orElse(DEFAULT_LOG_LEVEL);
    }

    void setMcastPort(Integer mcastPort) {
        this.mcastPort = mcastPort;
        this.locators = DEFAULT_LOCATORS;
    }

    protected Integer mcastPort() {
        return Optional.ofNullable(this.mcastPort).orElse(0);
    }

    void setName(String name) {
        this.name = name;
    }

    protected String name() {
        return Optional.ofNullable(this.name).filter(StringUtils::hasText).orElseGet(this::toString);
    }

    void setStartLocator(String startLocator) {
        this.startLocator = startLocator;
    }

    protected String startLocator() {
        return this.startLocator;
    }

    void setTransactionListeners(List<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    protected List<TransactionListener> getTransactionListeners() {
        return CollectionUtils.nullSafeList(this.transactionListeners);
    }

    void setTransactionWriter(TransactionWriter transactionWriter) {
        this.transactionWriter = transactionWriter;
    }

    protected TransactionWriter getTransactionWriter() {
        return this.transactionWriter;
    }

    void setUseBeanFactoryLocator(boolean useBeanFactoryLocator) {
        this.useBeanFactoryLocator = useBeanFactoryLocator;
    }

    protected boolean useBeanFactoryLocator() {
        return this.useBeanFactoryLocator;
    }

    public void add(Properties gemfireProperties) {
        this.customGemFireProperties.add(gemfireProperties);
    }

    public String toString() {
        return DEFAULT_NAME;
    }
}

