/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.util.ObjectUtils;

public enum ClientRegionShortcutWrapper {
    CACHING_PROXY(ClientRegionShortcut.CACHING_PROXY, DataPolicy.NORMAL),
    CACHING_PROXY_HEAP_LRU(ClientRegionShortcut.CACHING_PROXY_HEAP_LRU, DataPolicy.NORMAL),
    CACHING_PROXY_OVERFLOW(ClientRegionShortcut.CACHING_PROXY_OVERFLOW, DataPolicy.NORMAL),
    LOCAL(ClientRegionShortcut.LOCAL, DataPolicy.NORMAL),
    LOCAL_HEAP_LRU(ClientRegionShortcut.LOCAL_HEAP_LRU, DataPolicy.NORMAL),
    LOCAL_OVERFLOW(ClientRegionShortcut.LOCAL_OVERFLOW, DataPolicy.NORMAL),
    LOCAL_PERSISTENT(ClientRegionShortcut.LOCAL_PERSISTENT, DataPolicy.PERSISTENT_REPLICATE),
    LOCAL_PERSISTENT_OVERFLOW(ClientRegionShortcut.LOCAL_PERSISTENT_OVERFLOW, DataPolicy.PERSISTENT_REPLICATE),
    PROXY(ClientRegionShortcut.PROXY, DataPolicy.EMPTY),
    UNSPECIFIED(null, null);

    private final ClientRegionShortcut clientRegionShortcut;
    private final DataPolicy dataPolicy;

    public static ClientRegionShortcutWrapper valueOf(ClientRegionShortcut clientRegionShortcut) {
        for (ClientRegionShortcutWrapper wrapper : ClientRegionShortcutWrapper.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)wrapper.getClientRegionShortcut(), (Object)clientRegionShortcut)) continue;
            return wrapper;
        }
        return UNSPECIFIED;
    }

    private ClientRegionShortcutWrapper(ClientRegionShortcut clientRegionShortcut, DataPolicy dataPolicy) {
        this.clientRegionShortcut = clientRegionShortcut;
        this.dataPolicy = dataPolicy;
    }

    public ClientRegionShortcut getClientRegionShortcut() {
        return this.clientRegionShortcut;
    }

    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public boolean isCaching() {
        return this.name().contains("CACHING");
    }

    public boolean isHeapLru() {
        return this.name().contains("HEAP_LRU");
    }

    public boolean isLocal() {
        return this.name().contains("LOCAL");
    }

    public boolean isOverflow() {
        return this.name().contains("OVERFLOW");
    }

    public boolean isPersistent() {
        return this.name().contains("PERSISTENT");
    }

    public boolean isPersistentOverflow() {
        return this.name().contains("PERSISTENT_OVERFLOW");
    }

    public boolean isProxy() {
        return this.name().contains("PROXY");
    }
}

