/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;

public class PdxDiskStoreAwareBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String pdxDiskStoreName;

    public PdxDiskStoreAwareBeanFactoryPostProcessor(String pdxDiskStoreName) {
        Assert.hasText((String)pdxDiskStoreName, (String)"The PDX DiskStore name must be specified");
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    public String getPdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.postProcessPdxDiskStoreDependencies(beanFactory, AsyncEventQueue.class, DiskStore.class, Region.class);
    }

    private void postProcessPdxDiskStoreDependencies(ConfigurableListableBeanFactory beanFactory, Class<?> ... beanTypes) {
        for (Class<?> beanType : beanTypes) {
            for (String beanName : beanFactory.getBeanNamesForType(beanType)) {
                if (beanName.equalsIgnoreCase(this.getPdxDiskStoreName())) continue;
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                this.addPdxDiskStoreDependency(beanDefinition);
            }
        }
    }

    private void addPdxDiskStoreDependency(BeanDefinition beanDefinition) {
        String[] newDependsOn = (String[])ArrayUtils.insert(this.getDependsOn(beanDefinition), 0, this.getPdxDiskStoreName());
        beanDefinition.setDependsOn(newDependsOn);
    }

    private String[] getDependsOn(BeanDefinition beanDefinition) {
        return SpringUtils.defaultIfNull(beanDefinition.getDependsOn(), EMPTY_STRING_ARRAY);
    }
}

