/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.annotation.Id;
import org.springframework.data.gemfire.IndexFactoryBean;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.config.annotation.EnableIndexes;
import org.springframework.data.gemfire.config.annotation.EntityDefinedRegionsConfiguration;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.Indexed;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.util.StringUtils;

public class IndexConfiguration
extends EntityDefinedRegionsConfiguration {
    protected Class<? extends Annotation> getEnableIndexesAnnotationType() {
        return EnableIndexes.class;
    }

    protected String getEnableIndexesAnnotationTypeName() {
        return this.getEnableIndexesAnnotationType().getName();
    }

    protected String getEnableIndexesAnnotationTypeSimpleName() {
        return this.getEnableIndexesAnnotationType().getSimpleName();
    }

    @Override
    protected GemfirePersistentEntity<?> postProcess(AnnotationMetadata importingClassMetadata, final BeanDefinitionRegistry registry, GemfirePersistentEntity<?> persistentEntity) {
        final GemfirePersistentEntity<?> localPersistentEntity = super.postProcess(importingClassMetadata, registry, persistentEntity);
        if (this.isAnnotationPresent(importingClassMetadata, this.getEnableIndexesAnnotationTypeName())) {
            final AnnotationAttributes enableIndexesAttributes = this.getAnnotationAttributes(importingClassMetadata, this.getEnableIndexesAnnotationTypeName());
            localPersistentEntity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>(){

                public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                    Indexed indexedAnnotation;
                    Id idAnnotation = (Id)persistentProperty.findAnnotation(Id.class);
                    if (idAnnotation != null) {
                        IndexConfiguration.this.registerIndexBeanDefinition(enableIndexesAttributes, localPersistentEntity, persistentProperty, IndexType.KEY, (Annotation)idAnnotation, registry);
                    }
                    if ((indexedAnnotation = (Indexed)persistentProperty.findAnnotation(Indexed.class)) != null) {
                        IndexConfiguration.this.registerIndexBeanDefinition(enableIndexesAttributes, localPersistentEntity, persistentProperty, indexedAnnotation.type(), indexedAnnotation, registry);
                    }
                }
            });
        }
        return persistentEntity;
    }

    protected void registerIndexBeanDefinition(AnnotationAttributes enableIndexesAttributes, GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, IndexType indexType, Annotation indexAnnotation, BeanDefinitionRegistry registry) {
        if (indexAnnotation != null) {
            AnnotationAttributes indexAnnotationAttributes = AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((Annotation)indexAnnotation));
            BeanDefinitionBuilder indexFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(IndexFactoryBean.class);
            String indexName = this.resolveName(persistentEntity, persistentProperty, indexAnnotationAttributes, indexType);
            indexFactoryBeanBuilder.addPropertyReference("cache", "gemfireCache");
            indexFactoryBeanBuilder.addPropertyValue("define", (Object)this.resolveDefine(enableIndexesAttributes));
            indexFactoryBeanBuilder.addPropertyValue("expression", (Object)this.resolveExpression(persistentEntity, persistentProperty, indexAnnotationAttributes));
            indexFactoryBeanBuilder.addPropertyValue("from", (Object)this.resolveFrom(persistentEntity, persistentProperty, indexAnnotationAttributes));
            indexFactoryBeanBuilder.addPropertyValue("name", (Object)indexName);
            indexFactoryBeanBuilder.addPropertyValue("type", (Object)this.resolveType(persistentEntity, persistentProperty, indexAnnotationAttributes, indexType).toString());
            registry.registerBeanDefinition(indexName, (BeanDefinition)indexFactoryBeanBuilder.getBeanDefinition());
        }
    }

    private boolean resolveDefine(AnnotationAttributes enableIndexesAnnotationAttributes) {
        return enableIndexesAnnotationAttributes.containsKey((Object)"define") && enableIndexesAnnotationAttributes.getBoolean("define");
    }

    private String resolveExpression(GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, AnnotationAttributes indexAnnotationAttributes) {
        String expression = indexAnnotationAttributes.containsKey((Object)"expression") ? indexAnnotationAttributes.getString("expression") : null;
        return StringUtils.hasText((String)expression) ? expression : persistentProperty.getName();
    }

    private String resolveFrom(GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, AnnotationAttributes indexAnnotationAttributes) {
        String from = indexAnnotationAttributes.containsKey((Object)"from") ? indexAnnotationAttributes.getString("from") : null;
        return StringUtils.hasText((String)from) ? from : persistentEntity.getRegionName();
    }

    private String resolveName(GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, AnnotationAttributes indexAnnotationAttributes, IndexType indexType) {
        String indexName = indexAnnotationAttributes.containsKey((Object)"name") ? indexAnnotationAttributes.getString("name") : null;
        return StringUtils.hasText((String)indexName) ? indexName : this.generateIndexName(persistentEntity, persistentProperty, indexType);
    }

    private String generateIndexName(GemfirePersistentEntity persistentEntity, GemfirePersistentProperty persistentProperty, IndexType indexType) {
        return String.format("%1$s%2$s%3$sIdx", persistentEntity.getRegionName(), StringUtils.capitalize((String)persistentProperty.getName()), StringUtils.capitalize((String)indexType.name().toLowerCase()));
    }

    private IndexType resolveType(GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, AnnotationAttributes indexAnnotationAttributes, IndexType indexType) {
        IndexType resolvedIndexType = indexAnnotationAttributes.containsKey((Object)"type") ? (IndexType)indexAnnotationAttributes.getEnum("type") : null;
        return resolvedIndexType != null ? resolvedIndexType : indexType;
    }
}

