/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import com.gemstone.gemfire.cache.query.SelectResults;
import java.util.Collection;
import java.util.Collections;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.query.AbstractQueryPostProcessor;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StringBasedGemfireRepositoryQuery
extends GemfireRepositoryQuery {
    private static final String INVALID_QUERY = "Paging and modifying queries are not supported!";
    private boolean userDefinedQuery = false;
    private final GemfireTemplate template;
    private final QueryString query;

    StringBasedGemfireRepositoryQuery() {
        this.query = null;
        this.template = null;
        this.register(LimitQueryPostProcessor.INSTANCE.processBefore(ImportQueryPostProcessor.INSTANCE).processBefore(HintQueryPostProcessor.INSTANCE).processBefore(TraceQueryPostProcessor.INSTANCE));
    }

    public StringBasedGemfireRepositoryQuery(GemfireQueryMethod queryMethod, GemfireTemplate template) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, template);
    }

    public StringBasedGemfireRepositoryQuery(String query, GemfireQueryMethod queryMethod, GemfireTemplate template) {
        super(queryMethod);
        Assert.notNull((Object)template, (String)"GemfireTemplate must not be null");
        Assert.state((!queryMethod.isModifyingQuery() && !queryMethod.isPageQuery() ? 1 : 0) != 0, (String)INVALID_QUERY);
        this.userDefinedQuery |= !StringUtils.hasText((String)query);
        this.query = new QueryString(StringUtils.hasText((String)query) ? query : queryMethod.getAnnotatedQuery());
        this.template = template;
        this.register(LimitQueryPostProcessor.INSTANCE.processBefore(ImportQueryPostProcessor.INSTANCE).processBefore(HintQueryPostProcessor.INSTANCE).processBefore(TraceQueryPostProcessor.INSTANCE));
    }

    public StringBasedGemfireRepositoryQuery asUserDefinedQuery() {
        this.userDefinedQuery = true;
        return this;
    }

    public boolean isUserDefinedQuery() {
        return this.userDefinedQuery;
    }

    public Object execute(Object[] arguments) {
        QueryMethod queryMethod = this.getQueryMethod();
        QueryString query = this.isUserDefinedQuery() ? this.query : this.query.forRegion(queryMethod.getEntityInformation().getJavaType(), this.template.getRegion());
        ParametersParameterAccessor parameterAccessor = new ParametersParameterAccessor(queryMethod.getParameters(), arguments);
        for (Integer index : query.getInParameterIndexes()) {
            query = query.bindIn(this.toCollection(parameterAccessor.getBindableValue(index - 1)));
        }
        String queryString = this.getQueryPostProcessor().postProcess(queryMethod, query.toString(), arguments);
        SelectResults selectResults = this.template.find(queryString, arguments);
        Collection<?> result = this.toCollection(selectResults);
        if (queryMethod.isCollectionQuery()) {
            return result;
        }
        if (queryMethod.isQueryForEntity()) {
            if (result.isEmpty()) {
                return null;
            }
            if (result.size() == 1) {
                return result.iterator().next();
            }
            throw new IncorrectResultSizeDataAccessException(1, result.size());
        }
        if (this.isSingleResultNonEntityQuery(queryMethod, result)) {
            return result.iterator().next();
        }
        throw new IllegalStateException("Unsupported query: " + query.toString());
    }

    boolean isSingleResultNonEntityQuery(QueryMethod method, Collection<?> result) {
        return !method.isCollectionQuery() && method.getReturnedObjectType() != null && !Void.TYPE.equals(method.getReturnedObjectType()) && result != null && result.size() == 1;
    }

    Collection<?> toCollection(Object source) {
        if (source instanceof SelectResults) {
            return ((SelectResults)source).asList();
        }
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source == null) {
            return Collections.emptyList();
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singletonList(source);
    }

    protected static class TraceQueryPostProcessor
    extends AbstractQueryPostProcessor<Repository, String> {
        protected static final TraceQueryPostProcessor INSTANCE = new TraceQueryPostProcessor();

        protected TraceQueryPostProcessor() {
        }

        @Override
        public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
            GemfireQueryMethod gemfireQueryMethod;
            if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasTrace() && !QueryString.TRACE_PATTERN.matcher(query).find()) {
                query = QueryString.of(query).withTrace().toString();
            }
            return query;
        }
    }

    protected static class LimitQueryPostProcessor
    extends AbstractQueryPostProcessor<Repository, String> {
        protected static final LimitQueryPostProcessor INSTANCE = new LimitQueryPostProcessor();

        protected LimitQueryPostProcessor() {
        }

        @Override
        public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
            GemfireQueryMethod gemfireQueryMethod;
            if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasLimit() && !QueryString.LIMIT_PATTERN.matcher(query).find()) {
                query = QueryString.of(query).withLimit(gemfireQueryMethod.getLimit()).toString();
            }
            return query;
        }
    }

    protected static class ImportQueryPostProcessor
    extends AbstractQueryPostProcessor<Repository, String> {
        protected static final ImportQueryPostProcessor INSTANCE = new ImportQueryPostProcessor();

        protected ImportQueryPostProcessor() {
        }

        @Override
        public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
            GemfireQueryMethod gemfireQueryMethod;
            if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasImport() && !QueryString.IMPORT_PATTERN.matcher(query).find()) {
                query = QueryString.of(query).withImport(gemfireQueryMethod.getImport()).toString();
            }
            return query;
        }
    }

    protected static class HintQueryPostProcessor
    extends AbstractQueryPostProcessor<Repository, String> {
        protected static final HintQueryPostProcessor INSTANCE = new HintQueryPostProcessor();

        protected HintQueryPostProcessor() {
        }

        @Override
        public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
            GemfireQueryMethod gemfireQueryMethod;
            if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasHint() && !QueryString.HINT_PATTERN.matcher(query).find()) {
                query = QueryString.of(query).withHints(gemfireQueryMethod.getHints()).toString();
            }
            return query;
        }
    }
}

