/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableGemFireProperties;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class GemFirePropertiesConfiguration
extends EmbeddedServiceConfigurationSupport {
    public static final boolean DEFAULT_CONSERVE_SOCKETS = true;
    public static final boolean DEFAULT_DELTA_PROPAGATION = true;
    public static final boolean DEFAULT_DISABLE_TCP = false;
    public static final boolean DEFAULT_ENABLE_NETWORK_PARTITION_DETECTION = false;
    public static final boolean DEFAULT_ENFORCE_UNIQUE_HOST = false;
    public static final boolean DEFAULT_LOAD_CLUSTER_CONFIGURATION_FROM_DIRECTORY = false;
    public static final boolean DEFAULT_LOCK_MEMORY = false;
    public static final boolean DEFAULT_REMOVE_UNRESPONSIVE_CLIENT = false;
    public static final int DEFAULT_ACK_SEVERE_ALERT_THRESHOLD = 0;
    public static final int DEFAULT_ACK_WAIT_THRESHOLD = 15;
    public static final int DEFAULT_ASYNC_MAX_QUEUE_SIZE = 8;
    public static final int DEFAULT_DISTRIBUTED_SYSTEM_ID = -1;
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 32768;
    public static final int DEFAULT_TCP_PORT = 0;
    public static final int DEFAULT_TOMBSTONE_THRESHOLD = 100000;
    public static final int DEFAULT_UDP_FRAGMENT_SIZE = 60000;
    public static final int DEFAULT_UDP_RECEIVE_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_UDP_SEND_BUFFER_SIZE = 65535;
    public static final long DEFAULT_ASYNC_DISTRIBUTION_TIMEOUT = 0L;
    public static final long DEFAULT_ASYNC_QUEUE_TIMEOUT = 60000L;
    public static final long DEFAULT_LOCATOR_WAIT_TIME = 0L;
    public static final long DEFAULT_MAX_WAIT_TIME_RECONNECT = 60000L;
    public static final long DEFAULT_MEMBER_TIMEOUT = 5000L;
    public static final long DEFAULT_SOCKET_LEASE_TIME = 60000L;
    public static final String DEFAULT_CONFLATE_EVENTS = "server";
    public static final String DEFAULT_DEPLOY_WORKING_DIRECTORY = ".";
    public static final String DEFAULT_MEMBERSHIP_PORT_RANGE = "1024-65535";

    @Override
    protected Class getAnnotationType() {
        return EnableGemFireProperties.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = new PropertiesBuilder();
        gemfireProperties.setPropertyIfNotDefault("ack-severe-alert-threshold", annotationAttributes.get("ackSevereAlertThreshold"), 0);
        gemfireProperties.setPropertyIfNotDefault("ack-wait-threshold", annotationAttributes.get("ackWaitThreshold"), 15);
        gemfireProperties.setPropertyIfNotDefault("async-distribution-timeout", annotationAttributes.get("asyncDistributionTimeout"), 0L);
        gemfireProperties.setPropertyIfNotDefault("async-max-queue-size", annotationAttributes.get("asyncMaxQueueSize"), 8);
        gemfireProperties.setPropertyIfNotDefault("async-queue-timeout", annotationAttributes.get("asyncQueueTimeout"), 60000L);
        gemfireProperties.setProperty("bind-address", annotationAttributes.get("bindAddress"));
        gemfireProperties.setProperty("cache-xml-file", annotationAttributes.get("cacheXmlFile"));
        gemfireProperties.setProperty("cluster-configuration-dir", annotationAttributes.get("clusterConfigurationDirectory"));
        gemfireProperties.setPropertyIfNotDefault("conflate-events", annotationAttributes.get("conflateEvents"), DEFAULT_CONFLATE_EVENTS);
        gemfireProperties.setPropertyIfNotDefault("conserve-sockets", annotationAttributes.get("conserveSockets"), true);
        gemfireProperties.setPropertyIfNotDefault("delta-propagation", annotationAttributes.get("deltaPropagation"), true);
        gemfireProperties.setPropertyIfNotDefault("deploy-working-dir", annotationAttributes.get("deployWorkingDirectory"), DEFAULT_DEPLOY_WORKING_DIRECTORY);
        gemfireProperties.setPropertyIfNotDefault("disable-tcp", annotationAttributes.get("disableTcp"), false);
        gemfireProperties.setPropertyIfNotDefault("distributed-system-id", annotationAttributes.get("distributedSystemId"), -1);
        gemfireProperties.setPropertyIfNotDefault("enable-network-partition-detection", annotationAttributes.get("enableNetworkPartitionDetection"), false);
        gemfireProperties.setPropertyIfNotDefault("enforce-unique-host", annotationAttributes.get("enforceUniqueHost"), false);
        gemfireProperties.setProperty("groups", (String[])annotationAttributes.get("groups"));
        gemfireProperties.setPropertyIfNotDefault("load-cluster-configuration-from-dir", annotationAttributes.get("loadClusterConfigurationFromDirectory"), false);
        gemfireProperties.setPropertyIfNotDefault("locator-wait-time", annotationAttributes.get("locatorWaitTimeout"), 0L);
        gemfireProperties.setPropertyIfNotDefault("lock-memory", annotationAttributes.get("lockMemory"), false);
        gemfireProperties.setPropertyIfNotDefault("max-wait-time-reconnect", annotationAttributes.get("maxWaitTimeReconnect"), 60000L);
        gemfireProperties.setPropertyIfNotDefault("member-timeout", annotationAttributes.get("memberTimeout"), 5000L);
        gemfireProperties.setPropertyIfNotDefault("membership-port-range", annotationAttributes.get("membershipPortRange"), DEFAULT_MEMBERSHIP_PORT_RANGE);
        gemfireProperties.setProperty("redundancy-zone", annotationAttributes.get("redundancyZone"));
        gemfireProperties.setProperty("remote-locators", annotationAttributes.get("remoteLocators"));
        gemfireProperties.setPropertyIfNotDefault("remove-unresponsive-client", annotationAttributes.get("removeUnresponsiveClient"), false);
        gemfireProperties.setPropertyIfNotDefault("socket-buffer-size", annotationAttributes.get("socketBufferSize"), 32768);
        gemfireProperties.setPropertyIfNotDefault("socket-lease-time", annotationAttributes.get("socketLeaseTime"), 60000L);
        gemfireProperties.setPropertyIfNotDefault("tcp-port", annotationAttributes.get("tcpPort"), 0);
        gemfireProperties.setPropertyIfNotDefault("tombstone-gc-threshold", annotationAttributes.get("tombstoneGcThreshold"), 100000);
        gemfireProperties.setPropertyIfNotDefault("udp-fragment-size", annotationAttributes.get("udpFragmentSize"), 60000);
        gemfireProperties.setPropertyIfNotDefault("udp-recv-buffer-size", annotationAttributes.get("udpReceiveBufferSize"), 0x100000);
        gemfireProperties.setPropertyIfNotDefault("udp-send-buffer-size", annotationAttributes.get("udpSendBufferSize"), 65535);
        gemfireProperties.setProperty("user-command-packages", annotationAttributes.get("userCommandPackages"));
        return gemfireProperties.build();
    }
}

