/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import org.springframework.data.gemfire.repository.query.AbstractQueryPostProcessor;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.QueryPostProcessor;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public abstract class GemfireRepositoryQuery
implements RepositoryQuery {
    private final GemfireQueryMethod queryMethod;
    private QueryPostProcessor<?, String> queryPostProcessor = ProvidedQueryPostProcessor.INSTANCE;

    GemfireRepositoryQuery() {
        this.queryMethod = null;
    }

    public GemfireRepositoryQuery(GemfireQueryMethod queryMethod) {
        Assert.notNull((Object)((Object)queryMethod), (String)"QueryMethod must not be null");
        this.queryMethod = queryMethod;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected QueryPostProcessor<?, String> getQueryPostProcessor() {
        return this.queryPostProcessor;
    }

    public GemfireRepositoryQuery register(QueryPostProcessor<?, String> queryPostProcessor) {
        this.queryPostProcessor = this.queryPostProcessor.processBefore(queryPostProcessor);
        return this;
    }

    static class ProvidedQueryPostProcessor
    extends AbstractQueryPostProcessor<Repository, String> {
        static final ProvidedQueryPostProcessor INSTANCE = new ProvidedQueryPostProcessor();

        ProvidedQueryPostProcessor() {
        }

        @Override
        public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
            return query;
        }
    }
}

