/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GemFireComponentClassTypeScanner
implements Iterable<String> {
    private ClassLoader entityClassLoader;
    private ConfigurableApplicationContext applicationContext;
    private Set<TypeFilter> excludes = new HashSet<TypeFilter>();
    private Set<TypeFilter> includes = new HashSet<TypeFilter>();
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Set<String> basePackages;

    public static GemFireComponentClassTypeScanner from(String ... basePackages) {
        return new GemFireComponentClassTypeScanner(CollectionUtils.asSet(ArrayUtils.nullSafeArray(basePackages, String.class)));
    }

    public static GemFireComponentClassTypeScanner from(Iterable<String> basePackages) {
        HashSet<String> basePackageSet = new HashSet<String>();
        for (String basePackage : CollectionUtils.nullSafeIterable(basePackages)) {
            basePackageSet.add(basePackage);
        }
        return new GemFireComponentClassTypeScanner(basePackageSet);
    }

    protected GemFireComponentClassTypeScanner(Set<String> basePackages) {
        Assert.notEmpty(basePackages, (String)"Base packages must be specified");
        this.basePackages = basePackages;
    }

    protected ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected Set<String> getBasePackages() {
        return Collections.unmodifiableSet(this.basePackages);
    }

    protected ClassLoader getEntityClassLoader() {
        ConfigurableApplicationContext applicationContext = this.getApplicationContext();
        return this.entityClassLoader != null ? this.entityClassLoader : (applicationContext != null ? applicationContext.getBeanFactory().getBeanClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    protected Environment getEnvironment() {
        ConfigurableApplicationContext applicationContext = this.getApplicationContext();
        return applicationContext != null ? applicationContext.getEnvironment() : new StandardEnvironment();
    }

    protected Iterable<TypeFilter> getExcludes() {
        return this.excludes;
    }

    protected Iterable<TypeFilter> getIncludes() {
        return this.includes;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getBasePackages().iterator();
    }

    public Set<Class<?>> scan() {
        HashSet componentClasses = new HashSet();
        ClassLoader entityClassLoader = this.getEntityClassLoader();
        ClassPathScanningCandidateComponentProvider componentProvider = this.newClassPathScanningCandidateComponentProvider();
        for (String packageName : this) {
            for (BeanDefinition beanDefinition : componentProvider.findCandidateComponents(packageName)) {
                try {
                    componentClasses.add(ClassUtils.forName((String)beanDefinition.getBeanClassName(), (ClassLoader)entityClassLoader));
                }
                catch (ClassNotFoundException ignore) {
                    this.log.warn((Object)String.format("Class not found for component type [%s]", beanDefinition.getBeanClassName()));
                }
            }
        }
        return componentClasses;
    }

    protected ClassPathScanningCandidateComponentProvider newClassPathScanningCandidateComponentProvider() {
        return this.newClassPathScanningCandidateComponentProvider(false);
    }

    protected ClassPathScanningCandidateComponentProvider newClassPathScanningCandidateComponentProvider(boolean useDefaultFilters) {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(useDefaultFilters, this.getEnvironment());
        for (TypeFilter exclude : this.excludes) {
            componentProvider.addExcludeFilter(exclude);
        }
        for (TypeFilter include : this.includes) {
            componentProvider.addIncludeFilter(include);
        }
        return componentProvider;
    }

    public GemFireComponentClassTypeScanner with(ClassLoader entityClassLoader) {
        this.entityClassLoader = entityClassLoader;
        return this;
    }

    public GemFireComponentClassTypeScanner with(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public GemFireComponentClassTypeScanner withExcludes(TypeFilter ... excludes) {
        return this.withExcludes(CollectionUtils.asSet(ArrayUtils.nullSafeArray(excludes, TypeFilter.class)));
    }

    public GemFireComponentClassTypeScanner withExcludes(Iterable<TypeFilter> excludes) {
        for (TypeFilter exclude : CollectionUtils.nullSafeIterable(excludes)) {
            this.excludes.add(exclude);
        }
        return this;
    }

    public GemFireComponentClassTypeScanner withIncludes(TypeFilter ... includes) {
        return this.withIncludes(CollectionUtils.asSet(ArrayUtils.nullSafeArray(includes, TypeFilter.class)));
    }

    public GemFireComponentClassTypeScanner withIncludes(Iterable<TypeFilter> includes) {
        for (TypeFilter include : CollectionUtils.nullSafeIterable(includes)) {
            this.includes.add(include);
        }
        return this;
    }
}

