/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableCacheServer;
import org.springframework.data.gemfire.server.CacheServerFactoryBean;

public class AddCacheServerConfiguration
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (importingClassMetadata.hasAnnotation(EnableCacheServer.class.getName())) {
            Map enableCacheServerAttributes = importingClassMetadata.getAnnotationAttributes(EnableCacheServer.class.getName());
            this.registerCacheServerFactoryBeanDefinition(enableCacheServerAttributes, registry);
        }
    }

    protected void registerCacheServerFactoryBeanDefinition(Map<String, Object> enableCacheServerAttributes, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CacheServerFactoryBean.class);
        builder.addPropertyReference("cache", "gemfireCache");
        builder.addPropertyValue("autoStartup", enableCacheServerAttributes.get("autoStartup"));
        builder.addPropertyValue("bindAddress", enableCacheServerAttributes.get("bindAddress"));
        builder.addPropertyValue("hostNameForClients", enableCacheServerAttributes.get("hostnameForClients"));
        builder.addPropertyValue("loadPollInterval", enableCacheServerAttributes.get("loadPollInterval"));
        builder.addPropertyValue("maxConnections", enableCacheServerAttributes.get("maxConnections"));
        builder.addPropertyValue("maxMessageCount", enableCacheServerAttributes.get("maxMessageCount"));
        builder.addPropertyValue("maxThreads", enableCacheServerAttributes.get("maxThreads"));
        builder.addPropertyValue("maxTimeBetweenPings", enableCacheServerAttributes.get("maxTimeBetweenPings"));
        builder.addPropertyValue("messageTimeToLive", enableCacheServerAttributes.get("messageTimeToLive"));
        builder.addPropertyValue("port", enableCacheServerAttributes.get("port"));
        builder.addPropertyValue("socketBufferSize", enableCacheServerAttributes.get("socketBufferSize"));
        builder.addPropertyValue("subscriptionCapacity", enableCacheServerAttributes.get("subscriptionCapacity"));
        builder.addPropertyValue("subscriptionDiskStore", enableCacheServerAttributes.get("subscriptionDiskStoreName"));
        builder.addPropertyValue("subscriptionEvictionPolicy", enableCacheServerAttributes.get("subscriptionEvictionPolicy"));
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)registry);
    }
}

