/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.net.InetSocketAddress;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ConnectionEndpoint
implements Cloneable,
Comparable<ConnectionEndpoint> {
    protected static final int DEFAULT_PORT = 0;
    protected static final String DEFAULT_HOST = "localhost";
    private final int port;
    private final String host;

    public static ConnectionEndpoint from(InetSocketAddress socketAddress) {
        return new ConnectionEndpoint(socketAddress.getHostString(), socketAddress.getPort());
    }

    public static ConnectionEndpoint parse(String hostPort) {
        return ConnectionEndpoint.parse(hostPort, 0);
    }

    public static ConnectionEndpoint parse(String hostPort, int defaultPort) {
        Assert.hasText((String)hostPort, (String)"'hostPort' must be specified");
        String host = StringUtils.trimAllWhitespace((String)hostPort);
        int port = defaultPort;
        int portIndex = hostPort.indexOf("[");
        if (portIndex > -1) {
            port = ConnectionEndpoint.parsePort(ConnectionEndpoint.parseDigits(host.substring(portIndex)), defaultPort);
            host = host.substring(0, portIndex).trim();
        }
        return new ConnectionEndpoint(host, port);
    }

    static String parseDigits(String value) {
        StringBuilder digits = new StringBuilder();
        if (StringUtils.hasText((String)value)) {
            for (char character : value.toCharArray()) {
                if (!Character.isDigit(character)) continue;
                digits.append(character);
            }
        }
        return digits.toString();
    }

    static int parsePort(String port, int defaultPort) {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException ignore) {
            return defaultPort;
        }
    }

    public ConnectionEndpoint(String host, int port) {
        Assert.isTrue((port >= 0 && port <= 65535 ? 1 : 0) != 0, (String)String.format("port number (%1$d) must be between 0 and 65535", port));
        this.host = StringUtils.hasText((String)host) ? host : DEFAULT_HOST;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ConnectionEndpoint(this.getHost(), this.getPort());
    }

    @Override
    public int compareTo(ConnectionEndpoint connectionEndpoint) {
        int compareValue = this.getHost().compareTo(connectionEndpoint.getHost());
        return compareValue != 0 ? compareValue : this.getPort() - connectionEndpoint.getPort();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConnectionEndpoint)) {
            return false;
        }
        ConnectionEndpoint that = (ConnectionEndpoint)obj;
        return ObjectUtils.nullSafeEquals((Object)this.getHost(), (Object)that.getHost()) && ObjectUtils.nullSafeEquals((Object)this.getPort(), (Object)that.getPort());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getHost());
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getPort());
        return hashValue;
    }

    public String toString() {
        return String.format("%1$s[%2$d]", this.getHost(), this.getPort());
    }
}

