/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PartitionAttributesFactoryBean
implements FactoryBean<PartitionAttributes>,
InitializingBean {
    private final PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory();
    private List<PartitionListener> listeners;

    public PartitionAttributes getObject() throws Exception {
        return this.partitionAttributesFactory.create();
    }

    public Class<?> getObjectType() {
        return PartitionAttributes.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setColocatedWith(String colocatedRegionFullPath) {
        this.partitionAttributesFactory.setColocatedWith(colocatedRegionFullPath);
    }

    public void setFixedPartitionAttributes(List<FixedPartitionAttributes> fixedPartitionAttributes) {
        for (FixedPartitionAttributes fpa : fixedPartitionAttributes) {
            this.partitionAttributesFactory.addFixedPartitionAttributes(fpa);
        }
    }

    public void setLocalMaxMemory(int mb) {
        this.partitionAttributesFactory.setLocalMaxMemory(mb);
    }

    public void setPartitionResolver(PartitionResolver resolver) {
        this.partitionAttributesFactory.setPartitionResolver(resolver);
    }

    public void setPartitionListeners(List<PartitionListener> listeners) {
        this.listeners = listeners;
    }

    public void setRecoveryDelay(long recoveryDelay) {
        this.partitionAttributesFactory.setRecoveryDelay(recoveryDelay);
    }

    public void setRedundantCopies(int redundantCopies) {
        this.partitionAttributesFactory.setRedundantCopies(redundantCopies);
    }

    public void setStartupRecoveryDelay(long startupRecoveryDelay) {
        this.partitionAttributesFactory.setStartupRecoveryDelay(startupRecoveryDelay);
    }

    public void setTotalMaxMemory(long mb) {
        this.partitionAttributesFactory.setTotalMaxMemory(mb);
    }

    public void setTotalNumBuckets(int numBuckets) {
        this.partitionAttributesFactory.setTotalNumBuckets(numBuckets);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.listeners != null) {
            for (PartitionListener listener : this.listeners) {
                this.partitionAttributesFactory.addPartitionListener(listener);
            }
        }
    }
}

