/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PoolParser
extends AbstractSingleBeanDefinitionParser {
    protected static final int DEFAULT_LOCATOR_PORT = 10334;
    protected static final int DEFAULT_SERVER_PORT = 40404;
    protected static final Pattern PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{.+\\}");
    protected static final String DEFAULT_HOST = "localhost";
    protected static final String HOST_ATTRIBUTE_NAME = "host";
    protected static final String LOCATOR_ELEMENT_NAME = "locator";
    protected static final String LOCATORS_ATTRIBUTE_NAME = "locators";
    protected static final String PORT_ATTRIBUTE_NAME = "port";
    protected static final String SERVER_ELEMENT_NAME = "server";
    protected static final String SERVERS_ATTRIBUTE_NAME = "servers";

    PoolParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return PoolFactoryBean.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "free-connection-timeout");
        ParsingUtils.setPropertyValue(element, builder, "idle-timeout");
        ParsingUtils.setPropertyValue(element, builder, "load-conditioning-interval");
        ParsingUtils.setPropertyValue(element, builder, "keep-alive");
        ParsingUtils.setPropertyValue(element, builder, "max-connections");
        ParsingUtils.setPropertyValue(element, builder, "min-connections");
        ParsingUtils.setPropertyValue(element, builder, "multi-user-authentication");
        ParsingUtils.setPropertyValue(element, builder, "ping-interval");
        ParsingUtils.setPropertyValue(element, builder, "pr-single-hop-enabled");
        ParsingUtils.setPropertyValue(element, builder, "read-timeout");
        ParsingUtils.setPropertyValue(element, builder, "retry-attempts");
        ParsingUtils.setPropertyValue(element, builder, "server-group");
        ParsingUtils.setPropertyValue(element, builder, "socket-buffer-size");
        ParsingUtils.setPropertyValue(element, builder, "statistic-interval");
        ParsingUtils.setPropertyValue(element, builder, "subscription-ack-interval");
        ParsingUtils.setPropertyValue(element, builder, "subscription-enabled");
        ParsingUtils.setPropertyValue(element, builder, "subscription-message-tracking-timeout");
        ParsingUtils.setPropertyValue(element, builder, "subscription-redundancy");
        ParsingUtils.setPropertyValue(element, builder, "thread-local-connections");
        List childElements = DomUtils.getChildElements((Element)element);
        ManagedList locators = new ManagedList(childElements.size());
        ManagedList servers = new ManagedList(childElements.size());
        for (Element childElement : childElements) {
            String childElementName = childElement.getLocalName();
            if (LOCATOR_ELEMENT_NAME.equals(childElementName)) {
                locators.add((Object)this.parseLocator(childElement));
            }
            if (!SERVER_ELEMENT_NAME.equals(childElementName)) continue;
            servers.add((Object)this.parseServer(childElement));
        }
        locators.addAll(this.parseLocators(element, builder));
        servers.addAll(this.parseServers(element, builder));
        if (childElements.isEmpty() && !this.hasAttributes(element, LOCATORS_ATTRIBUTE_NAME, SERVERS_ATTRIBUTE_NAME)) {
            locators.add((Object)this.buildConnection(DEFAULT_HOST, String.valueOf(10334), false));
        }
        if (!locators.isEmpty()) {
            builder.addPropertyValue("locatorEndpoints", (Object)locators);
        }
        if (!servers.isEmpty()) {
            builder.addPropertyValue("serverEndpoints", (Object)servers);
        }
    }

    boolean hasAttributes(Element element, String ... attributeNames) {
        for (String attributeName : attributeNames) {
            if (!element.hasAttribute(attributeName)) continue;
            return true;
        }
        return false;
    }

    BeanDefinition buildConnections(String propertyPlaceholder, boolean server) {
        BeanDefinitionBuilder connectionEndpointListBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionEndpointList.class);
        connectionEndpointListBuilder.setFactoryMethod("parse");
        connectionEndpointListBuilder.addConstructorArgValue((Object)this.defaultPort(null, server));
        connectionEndpointListBuilder.addConstructorArgValue((Object)propertyPlaceholder);
        return connectionEndpointListBuilder.getBeanDefinition();
    }

    BeanDefinition buildConnection(String host, String port, boolean server) {
        BeanDefinitionBuilder connectionEndpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionEndpoint.class);
        connectionEndpointBuilder.addConstructorArgValue((Object)this.defaultHost(host));
        connectionEndpointBuilder.addConstructorArgValue((Object)this.defaultPort(port, server));
        return connectionEndpointBuilder.getBeanDefinition();
    }

    String defaultHost(String host) {
        return StringUtils.hasText((String)host) ? host : DEFAULT_HOST;
    }

    String defaultPort(String port, boolean server) {
        return StringUtils.hasText((String)port) ? port : (server ? String.valueOf(40404) : String.valueOf(10334));
    }

    List<BeanDefinition> parseConnections(String hostPortCommaDelimitedList, boolean server) {
        List<BeanDefinition> connections = Collections.emptyList();
        if (StringUtils.hasText((String)hostPortCommaDelimitedList)) {
            String[] hostsPorts = hostPortCommaDelimitedList.split(",");
            connections = new ArrayList<BeanDefinition>(hostsPorts.length);
            for (String hostPort : hostsPorts) {
                connections.add(this.parseConnection(hostPort, server));
            }
        }
        return connections;
    }

    BeanDefinition parseConnection(String hostPort, boolean server) {
        String host = hostPort.trim();
        String port = this.defaultPort(null, server);
        int portIndex = host.indexOf(91);
        if (portIndex > -1) {
            port = this.parseDigits(host.substring(portIndex)).trim();
            host = host.substring(0, portIndex).trim();
        }
        return this.buildConnection(host, port, server);
    }

    String parseDigits(String value) {
        StringBuilder digits = new StringBuilder();
        for (char character : value.toCharArray()) {
            if (!Character.isDigit(character)) continue;
            digits.append(character);
        }
        return digits.toString();
    }

    boolean isPropertyPlaceholder(String value) {
        return PROPERTY_PLACEHOLDER_PATTERN.matcher(value).matches();
    }

    BeanDefinition parseLocator(Element element) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), false);
    }

    List<BeanDefinition> parseLocators(Element element, BeanDefinitionBuilder builder) {
        List<BeanDefinition> beanDefinitions = Collections.emptyList();
        String locatorsAttributeValue = element.getAttribute(LOCATORS_ATTRIBUTE_NAME);
        if (this.isPropertyPlaceholder(locatorsAttributeValue)) {
            builder.addPropertyValue("locatorEndpointList", (Object)this.buildConnections(locatorsAttributeValue, false));
        } else {
            beanDefinitions = this.parseConnections(locatorsAttributeValue, false);
        }
        return beanDefinitions;
    }

    BeanDefinition parseServer(Element element) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), true);
    }

    List<BeanDefinition> parseServers(Element element, BeanDefinitionBuilder builder) {
        List<BeanDefinition> beanDefinitions = Collections.emptyList();
        String serversAttributeValue = element.getAttribute(SERVERS_ATTRIBUTE_NAME);
        if (this.isPropertyPlaceholder(serversAttributeValue)) {
            builder.addPropertyValue("serverEndpointList", (Object)this.buildConnections(serversAttributeValue, true));
        } else {
            beanDefinitions = this.parseConnections(serversAttributeValue, true);
        }
        return beanDefinitions;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)id)) {
            id = "DEFAULT";
            parserContext.getRegistry().registerAlias("DEFAULT", "gemfirePool");
            parserContext.getRegistry().registerAlias("DEFAULT", "gemfire-pool");
        }
        return id;
    }
}

