/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.repository.query.Predicate;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

class QueryBuilder {
    static final String DEFAULT_ALIAS = "x";
    private final String query;

    public QueryBuilder(String source) {
        Assert.hasText((String)source, (String)"The OQL Query must be specified");
        this.query = source;
    }

    public QueryBuilder(GemfirePersistentEntity<?> entity, PartTree tree) {
        this(String.format("SELECT%1$s * FROM /%2$s %3$s", tree.isDistinct() ? " DISTINCT" : "", entity.getRegionName(), DEFAULT_ALIAS));
    }

    public QueryString create(Predicate predicate) {
        return new QueryString(predicate != null ? String.format("%1$s WHERE %2$s", this.query, predicate.toString(DEFAULT_ALIAS)) : this.query);
    }

    public String toString() {
        return this.query;
    }
}

