/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.management.internal.cli.util.spring.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.data.gemfire.wan.GatewayProxy;
import org.springframework.data.gemfire.wan.StartupPolicyType;
import org.springframework.util.Assert;

public class GatewayHubFactoryBean
extends AbstractWANComponentFactoryBean<GatewayHub> {
    private Boolean manualStart;
    private GatewayHub gatewayHub;
    private Integer maxConnections;
    private Integer maximumTimeBetweenPings;
    private Integer port;
    private Integer socketBufferSize;
    private List<GatewayProxy> gateways;
    private StartupPolicyType startupPolicy;
    private String bindAddress;

    public GatewayHubFactoryBean(Cache cache) {
        super(cache);
    }

    @Override
    public GatewayHub getObject() throws Exception {
        return this.gatewayHub;
    }

    @Override
    public Class<?> getObjectType() {
        return this.gatewayHub != null ? this.gatewayHub.getClass() : GatewayHub.class;
    }

    @Override
    protected void doInit() {
        this.gatewayHub = this.cache.addGatewayHub(this.getName(), this.getPort().intValue());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Adding GemFire GatewayHub (%1$s)", this.getName()));
        }
        Assert.notNull((Object)this.cache.getGatewayHub(this.getName()));
        this.gatewayHub.setBindAddress(this.getBindAddress());
        this.gatewayHub.setManualStart(this.isManualStart(false));
        this.gatewayHub.setMaxConnections(this.getMaxConnections().intValue());
        this.gatewayHub.setMaximumTimeBetweenPings(this.getMaximumTimeBetweenPings().intValue());
        this.gatewayHub.setSocketBufferSize(this.getSocketBufferSize().intValue());
        this.gatewayHub.setStartupPolicy(this.getStartupPolicy().getName());
        this.configureGateways();
        this.autoStart();
    }

    private void configureGateways() {
        for (GatewayProxy gatewayProxy : this.getGateways()) {
            Gateway gateway = this.gatewayHub.addGateway(gatewayProxy.getId(), gatewayProxy.getConcurrencyLevel().intValue());
            for (GatewayProxy.GatewayEndpoint endpoint : gatewayProxy.getEndpoints()) {
                gateway.addEndpoint(endpoint.getId(), endpoint.getHost(), endpoint.getPort());
            }
            for (GatewayEventListener listener : gatewayProxy.getListeners()) {
                gateway.addListener(listener);
            }
            gateway.setOrderPolicy(gatewayProxy.getOrderPolicy());
            gateway.setSocketBufferSize(gatewayProxy.getSocketBufferSize().intValue());
            gateway.setSocketReadTimeout(gatewayProxy.getSocketReadTimeout().intValue());
            if (gatewayProxy.getQueue() == null) continue;
            GatewayProxy.GatewayQueue queue = gatewayProxy.getQueue();
            GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
            queueAttributes.setAlertThreshold(queue.getAlertThreshold().intValue());
            queueAttributes.setBatchConflation(queue.getEnableBatchConflation().booleanValue());
            queueAttributes.setBatchSize(queue.getBatchSize().intValue());
            queueAttributes.setBatchTimeInterval(queue.getBatchTimeInterval().intValue());
            queueAttributes.setMaximumQueueMemory(queue.getMaximumQueueMemory().intValue());
            queueAttributes.setEnablePersistence(queue.getPersistent().booleanValue());
            if (queue.getDiskStoreRef() == null) continue;
            queueAttributes.setDiskStoreName(queue.getDiskStoreRef());
        }
    }

    private void autoStart() {
        if (!this.gatewayHub.getManualStart()) {
            try {
                this.gatewayHub.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    String getBindAddress() {
        return StringUtils.hasText((String)this.bindAddress) ? this.bindAddress : GatewayHub.DEFAULT_BIND_ADDRESS;
    }

    public void setGateways(List<GatewayProxy> gateways) {
        this.gateways = gateways;
    }

    List<GatewayProxy> getGateways() {
        return this.gateways != null ? this.gateways : Collections.emptyList();
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = manualStart;
    }

    boolean isManualStart(boolean defaultManualStart) {
        return this.manualStart != null ? this.manualStart : defaultManualStart;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    Integer getMaxConnections() {
        return this.maxConnections != null ? this.maxConnections : 800;
    }

    public void setMaximumTimeBetweenPings(Integer maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    Integer getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings != null ? this.maximumTimeBetweenPings : 60000;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    Integer getPort() {
        return this.port != null ? this.port : -1;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    Integer getSocketBufferSize() {
        return this.socketBufferSize != null ? this.socketBufferSize : 32768;
    }

    public void setStartupPolicy(StartupPolicyType startupPolicy) {
        this.startupPolicy = startupPolicy;
    }

    StartupPolicyType getStartupPolicy() {
        return this.startupPolicy != null ? this.startupPolicy : StartupPolicyType.DEFAULT;
    }
}

