/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.gemfire.ExpirationActionConverter;
import org.springframework.data.gemfire.ExpirationActionType;
import org.springframework.data.gemfire.support.Expiration;
import org.springframework.data.gemfire.support.IdleTimeoutExpiration;
import org.springframework.data.gemfire.support.TimeToLiveExpiration;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class AnnotationBasedExpiration<K, V>
implements BeanFactoryAware,
CustomExpiry<K, V> {
    protected static final AtomicReference<BeanFactory> BEAN_FACTORY_REFERENCE = new AtomicReference<Object>(null);
    protected static final AtomicReference<StandardEvaluationContext> EVALUATION_CONTEXT_REFERENCE = new AtomicReference<Object>(null);
    private ExpirationAttributes defaultExpirationAttributes;

    public AnnotationBasedExpiration() {
        this(null);
    }

    public AnnotationBasedExpiration(ExpirationAttributes defaultExpirationAttributes) {
        this.defaultExpirationAttributes = defaultExpirationAttributes;
    }

    public static <K, V> AnnotationBasedExpiration<K, V> forIdleTimeout() {
        return AnnotationBasedExpiration.forIdleTimeout(null);
    }

    public static <K, V> AnnotationBasedExpiration<K, V> forIdleTimeout(ExpirationAttributes defaultExpirationAttributes) {
        return new AnnotationBasedExpiration<K, V>(defaultExpirationAttributes){

            @Override
            protected ExpirationMetaData getExpirationMetaData(Region.Entry<K, V> entry) {
                return this.isIdleTimeoutConfigured(entry) ? ExpirationMetaData.from(this.getIdleTimeout(entry)) : super.getExpirationMetaData(entry);
            }
        };
    }

    public static <K, V> AnnotationBasedExpiration<K, V> forTimeToLive() {
        return AnnotationBasedExpiration.forTimeToLive(null);
    }

    public static <K, V> AnnotationBasedExpiration<K, V> forTimeToLive(ExpirationAttributes defaultExpirationAttributes) {
        return new AnnotationBasedExpiration<K, V>(defaultExpirationAttributes){

            @Override
            protected ExpirationMetaData getExpirationMetaData(Region.Entry<K, V> entry) {
                return this.isTimeToLiveConfigured(entry) ? ExpirationMetaData.from(this.getTimeToLive(entry)) : super.getExpirationMetaData(entry);
            }
        };
    }

    protected void initEvaluationContext() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (EVALUATION_CONTEXT_REFERENCE.compareAndSet(null, this.newEvaluationContext())) {
            StandardEvaluationContext evaluationContext = EVALUATION_CONTEXT_REFERENCE.get();
            evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
            evaluationContext.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
            evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
            if (beanFactory instanceof ConfigurableBeanFactory) {
                ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
                ConversionService conversionService = configurableBeanFactory.getConversionService();
                if (conversionService != null) {
                    evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
                }
                evaluationContext.setTypeLocator((TypeLocator)new StandardTypeLocator(configurableBeanFactory.getBeanClassLoader()));
            }
        }
        EVALUATION_CONTEXT_REFERENCE.get().setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
    }

    StandardEvaluationContext newEvaluationContext() {
        return new StandardEvaluationContext();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        BEAN_FACTORY_REFERENCE.set(beanFactory);
        this.initEvaluationContext();
    }

    protected BeanFactory getBeanFactory() {
        BeanFactory localBeanFactory = BEAN_FACTORY_REFERENCE.get();
        Assert.state((localBeanFactory != null ? 1 : 0) != 0, (String)"beanFactory was not properly initialized");
        return localBeanFactory;
    }

    public void setDefaultExpirationAttributes(ExpirationAttributes defaultExpirationAttributes) {
        this.defaultExpirationAttributes = defaultExpirationAttributes;
    }

    protected ExpirationAttributes getDefaultExpirationAttributes() {
        return this.defaultExpirationAttributes;
    }

    public ExpirationAttributes getExpiry(Region.Entry<K, V> entry) {
        return this.newExpirationAttributes(this.getExpirationMetaData(entry));
    }

    protected ExpirationMetaData getExpirationMetaData(Region.Entry<K, V> entry) {
        return this.isExpirationConfigured(entry) ? ExpirationMetaData.from(this.getExpiration(entry)) : null;
    }

    protected ExpirationAttributes newExpirationAttributes(ExpirationMetaData expirationMetaData) {
        return expirationMetaData != null ? expirationMetaData.toExpirationAttributes() : this.getDefaultExpirationAttributes();
    }

    protected boolean isExpirationConfigured(Region.Entry<K, V> entry) {
        return this.isAnnotationPresent(entry.getValue(), Expiration.class);
    }

    protected Expiration getExpiration(Region.Entry<K, V> entry) {
        return this.getAnnotation(entry.getValue(), Expiration.class);
    }

    protected boolean isIdleTimeoutConfigured(Region.Entry<K, V> entry) {
        return this.isAnnotationPresent(entry.getValue(), IdleTimeoutExpiration.class);
    }

    protected IdleTimeoutExpiration getIdleTimeout(Region.Entry<K, V> entry) {
        return this.getAnnotation(entry.getValue(), IdleTimeoutExpiration.class);
    }

    protected boolean isTimeToLiveConfigured(Region.Entry<K, V> entry) {
        return this.isAnnotationPresent(entry.getValue(), TimeToLiveExpiration.class);
    }

    protected TimeToLiveExpiration getTimeToLive(Region.Entry<K, V> entry) {
        return this.getAnnotation(entry.getValue(), TimeToLiveExpiration.class);
    }

    private <T extends Annotation> boolean isAnnotationPresent(Object obj, Class<T> annotationType) {
        return obj != null && obj.getClass().isAnnotationPresent(annotationType);
    }

    private <T extends Annotation> T getAnnotation(Object obj, Class<T> annotationType) {
        return (T)AnnotationUtils.getAnnotation(obj.getClass(), annotationType);
    }

    public void close() {
    }

    protected static class ExpirationMetaData {
        private static final ExpirationActionConverter EXPIRATION_ACTION_CONVERTER = new ExpirationActionConverter();
        private final int timeout;
        private final ExpirationActionType action;

        protected ExpirationMetaData(int timeout, ExpirationActionType action) {
            this.timeout = timeout;
            this.action = action;
        }

        protected static ExpirationMetaData from(ExpirationAttributes expirationAttributes) {
            return new ExpirationMetaData(expirationAttributes.getTimeout(), ExpirationActionType.valueOf(expirationAttributes.getAction()));
        }

        protected static ExpirationMetaData from(Expiration expiration) {
            return new ExpirationMetaData(ExpirationMetaData.parseTimeout(expiration.timeout()), ExpirationMetaData.parseAction(expiration.action()));
        }

        protected static ExpirationMetaData from(IdleTimeoutExpiration expiration) {
            return new ExpirationMetaData(ExpirationMetaData.parseTimeout(expiration.timeout()), ExpirationMetaData.parseAction(expiration.action()));
        }

        protected static ExpirationMetaData from(TimeToLiveExpiration expiration) {
            return new ExpirationMetaData(ExpirationMetaData.parseTimeout(expiration.timeout()), ExpirationMetaData.parseAction(expiration.action()));
        }

        public ExpirationAttributes toExpirationAttributes() {
            return new ExpirationAttributes(this.timeout(), this.expirationAction());
        }

        protected static int parseTimeout(String timeout) {
            try {
                return Integer.parseInt(timeout);
            }
            catch (NumberFormatException cause) {
                try {
                    return (Integer)new SpelExpressionParser().parseExpression(timeout).getValue((EvaluationContext)EVALUATION_CONTEXT_REFERENCE.get(), Integer.TYPE);
                }
                catch (ParseException e) {
                    if (BEAN_FACTORY_REFERENCE.get() instanceof ConfigurableBeanFactory) {
                        return Integer.parseInt(((ConfigurableBeanFactory)BEAN_FACTORY_REFERENCE.get()).resolveEmbeddedValue(timeout));
                    }
                    throw cause;
                }
            }
        }

        protected static ExpirationActionType parseAction(String action) {
            try {
                return ExpirationActionType.valueOf(EXPIRATION_ACTION_CONVERTER.convert(action));
            }
            catch (IllegalArgumentException cause) {
                EvaluationException evaluationException = new EvaluationException(String.format("'%1$s' is not resolvable as a valid ExpirationAction(Type)", action), (Throwable)cause);
                EvaluationContext evaluationContext = (EvaluationContext)EVALUATION_CONTEXT_REFERENCE.get();
                try {
                    Expression expression = new SpelExpressionParser().parseExpression(action);
                    Class valueType = expression.getValueType(evaluationContext);
                    if (String.class.equals((Object)valueType)) {
                        return ExpirationActionType.valueOf(EXPIRATION_ACTION_CONVERTER.convert((String)expression.getValue(evaluationContext, String.class)));
                    }
                    if (ExpirationAction.class.equals((Object)valueType)) {
                        return ExpirationActionType.valueOf((ExpirationAction)expression.getValue(evaluationContext, ExpirationAction.class));
                    }
                    if (ExpirationActionType.class.equals((Object)valueType)) {
                        return (ExpirationActionType)((Object)expression.getValue(evaluationContext, ExpirationActionType.class));
                    }
                    throw evaluationException;
                }
                catch (ParseException e) {
                    if (BEAN_FACTORY_REFERENCE.get() instanceof ConfigurableBeanFactory) {
                        try {
                            String resolvedValue = ((ConfigurableBeanFactory)BEAN_FACTORY_REFERENCE.get()).resolveEmbeddedValue(action);
                            return ExpirationActionType.valueOf(EXPIRATION_ACTION_CONVERTER.convert(resolvedValue));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    throw evaluationException;
                }
            }
        }

        public ExpirationActionType action() {
            return this.action;
        }

        public ExpirationAction expirationAction() {
            return this.action().getExpirationAction();
        }

        public int timeout() {
            return this.timeout;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExpirationMetaData)) {
                return false;
            }
            ExpirationMetaData that = (ExpirationMetaData)obj;
            return this.timeout() == that.timeout() && ObjectUtils.nullSafeEquals((Object)((Object)this.action()), (Object)((Object)that.action()));
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.timeout());
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)((Object)this.action()));
            return hashValue;
        }

        public String toString() {
            return String.format("{ @type = %1$s, timeout = %2$d, action = %3$s }", new Object[]{this.getClass().getName(), this.timeout(), this.action()});
        }
    }
}

