/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.wan.GatewayHubFactoryBean;
import org.springframework.data.gemfire.wan.GatewayProxy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class GatewayHubParser
extends AbstractSimpleBeanDefinitionParser {
    GatewayHubParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return GatewayHubFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addConstructorArgReference(ParsingUtils.resolveCacheReference(element.getAttribute("cache-ref")));
        builder.setLazyInit(false);
        ParsingUtils.setPropertyValue(element, builder, "bind-address");
        ParsingUtils.setPropertyValue(element, builder, "manual-start");
        ParsingUtils.setPropertyValue(element, builder, "max-connections");
        ParsingUtils.setPropertyValue(element, builder, "max-time-between-pings", "maximumTimeBetweenPings");
        ParsingUtils.setPropertyValue(element, builder, "port");
        ParsingUtils.setPropertyValue(element, builder, "socket-buffer-size");
        ParsingUtils.setPropertyValue(element, builder, "startup-policy");
        this.parseGateways(element, parserContext, builder);
    }

    private void parseGateways(Element element, ParserContext parserContext, BeanDefinitionBuilder gatewayHubBuilder) {
        List gatewayElements = DomUtils.getChildElementsByTagName((Element)element, (String)"gateway");
        if (!CollectionUtils.isEmpty((Collection)gatewayElements)) {
            ManagedList gateways = new ManagedList();
            for (Element gatewayElement : gatewayElements) {
                BeanDefinitionBuilder gatewayBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayProxy.class);
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "gateway-id", "id");
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "concurrency-level");
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "order-policy");
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "socket-buffer-size");
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "socket-read-timeout");
                this.parseGatewayEndpoints(gatewayElement, gatewayBuilder);
                this.parseGatewayListeners(gatewayElement, parserContext, gatewayBuilder);
                this.parseGatewayQueue(gatewayElement, gatewayBuilder);
                gateways.add((Object)gatewayBuilder.getBeanDefinition());
            }
            gatewayHubBuilder.addPropertyValue("gateways", (Object)gateways);
        }
    }

    private void parseGatewayEndpoints(Element gatewayElement, BeanDefinitionBuilder gatewayBuilder) {
        List endpointElements = DomUtils.getChildElementsByTagName((Element)gatewayElement, (String)"gateway-endpoint");
        if (!CollectionUtils.isEmpty((Collection)endpointElements)) {
            ManagedList endpoints = new ManagedList();
            for (Element endpointElement : endpointElements) {
                BeanDefinitionBuilder endpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayProxy.GatewayEndpoint.class);
                ParsingUtils.setPropertyValue(endpointElement, endpointBuilder, "endpoint-id", "id");
                ParsingUtils.setPropertyValue(endpointElement, endpointBuilder, "host");
                ParsingUtils.setPropertyValue(endpointElement, endpointBuilder, "port");
                endpoints.add((Object)endpointBuilder.getBeanDefinition());
            }
            gatewayBuilder.addPropertyValue("endpoints", (Object)endpoints);
        }
    }

    private void parseGatewayListeners(Element gatewayElement, ParserContext parserContext, BeanDefinitionBuilder gatewayBuilder) {
        Element gatewayListenerElement = DomUtils.getChildElementByTagName((Element)gatewayElement, (String)"gateway-listener");
        if (gatewayListenerElement != null) {
            gatewayBuilder.addPropertyValue("listeners", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, gatewayListenerElement, gatewayBuilder));
        }
    }

    private void parseGatewayQueue(Element gatewayElement, BeanDefinitionBuilder gatewayBuilder) {
        Element gatewayQueueElement = DomUtils.getChildElementByTagName((Element)gatewayElement, (String)"gateway-queue");
        if (gatewayQueueElement != null) {
            BeanDefinitionBuilder queueBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayProxy.GatewayQueue.class);
            ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "alert-threshold");
            ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "batch-size");
            ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "batch-time-interval");
            ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "disk-store-ref");
            ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "enable-batch-conflation");
            ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "maximum-queue-memory");
            ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "persistent");
            if (gatewayQueueElement.hasAttribute("disk-store-ref")) {
                gatewayBuilder.getBeanDefinition().setDependsOn(new String[]{gatewayQueueElement.getAttribute("disk-store-ref")});
            }
            gatewayBuilder.addPropertyValue("queue", (Object)queueBuilder.getBeanDefinition());
        }
    }
}

