/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.management.internal.cli.util.spring.StringUtils;

public enum ScopeType {
    DISTRIBUTED_ACK(Scope.DISTRIBUTED_ACK),
    DISTRIBUTED_NO_ACK(Scope.DISTRIBUTED_NO_ACK),
    GLOBAL(Scope.GLOBAL),
    LOCAL(Scope.LOCAL);

    private final Scope gemfireScope;

    private ScopeType(Scope gemfireScope) {
        this.gemfireScope = gemfireScope;
    }

    public static Scope getScope(ScopeType scopeType) {
        return scopeType != null ? scopeType.getScope() : null;
    }

    public static ScopeType valueOf(Scope scope) {
        for (ScopeType scopeType : ScopeType.values()) {
            if (!scopeType.getScope().equals(scope)) continue;
            return scopeType;
        }
        return null;
    }

    public static ScopeType valueOfIgnoreCase(String name) {
        name = ScopeType.transform(name);
        for (ScopeType scopeType : ScopeType.values()) {
            if (!scopeType.name().equalsIgnoreCase(name)) continue;
            return scopeType;
        }
        return null;
    }

    private static String transform(String name) {
        return StringUtils.hasText((String)name) ? name.trim().replaceAll("-", "_") : name;
    }

    public Scope getScope() {
        return this.gemfireScope;
    }
}

