/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.lang.reflect.Method;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.gemfire.function.execution.DefaultFunctionExecutionMethodMetadata;
import org.springframework.data.gemfire.function.execution.FunctionExecutionMethodMetadata;
import org.springframework.data.gemfire.function.execution.GemfireFunctionOperations;
import org.springframework.data.gemfire.function.execution.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GemfireFunctionProxyFactoryBean
implements FactoryBean<Object>,
MethodInterceptor,
BeanClassLoaderAware {
    protected volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    protected final Class<?> serviceInterface;
    protected volatile Object serviceProxy;
    private volatile boolean initialized;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected final GemfireFunctionOperations gemfireFunctionOperations;
    private FunctionExecutionMethodMetadata<MethodMetadata> methodMetadata;

    public GemfireFunctionProxyFactoryBean(Class<?> serviceInterface, GemfireFunctionOperations gemfireFunctionOperations) {
        Assert.notNull(serviceInterface, (String)"'serviceInterface' must not be null");
        Assert.isTrue((boolean)serviceInterface.isInterface(), (String)"'serviceInterface' must be an interface");
        this.serviceInterface = serviceInterface;
        this.gemfireFunctionOperations = gemfireFunctionOperations;
        this.methodMetadata = new DefaultFunctionExecutionMethodMetadata(serviceInterface);
    }

    protected Object invokeFunction(Method method, Object[] args) {
        MethodMetadata mmd = this.methodMetadata.getMethodMetadata(method);
        return this.gemfireFunctionOperations.executeAndExtract(mmd.getFunctionId(), args);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (AopUtils.isToStringMethod((Method)invocation.getMethod())) {
            return "Gemfire function proxy for service interface [" + this.serviceInterface + "]";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("invoking method " + invocation.getMethod().getName()));
        }
        return this.invokeFunction(invocation.getMethod(), invocation.getArguments());
    }

    public Object getObject() throws Exception {
        if (this.serviceProxy == null) {
            this.onInit();
            Assert.notNull((Object)this.serviceProxy, (String)"failed to initialize proxy");
        }
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface != null ? this.serviceInterface : null;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void onInit() {
        if (this.initialized) {
            return;
        }
        ProxyFactory proxyFactory = new ProxyFactory(this.serviceInterface, (Interceptor)this);
        this.serviceProxy = proxyFactory.getProxy(this.beanClassLoader);
        this.initialized = true;
    }
}

