/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.management.internal.cli.domain.RegionInformation;
import com.gemstone.gemfire.management.internal.cli.functions.GetRegionsFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.function.execution.GemfireOnServersFunctionTemplate;
import org.springframework.data.gemfire.support.ListRegionsOnServerFunction;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GemfireDataSourcePostProcessor
implements BeanFactoryPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ClientCache clientCache;

    public GemfireDataSourcePostProcessor(ClientCache clientCache) {
        this.clientCache = clientCache;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.createClientRegionProxies(beanFactory, this.regionNames());
    }

    Iterable<String> regionNames() {
        try {
            return (Iterable)this.execute(new ListRegionsOnServerFunction(), new Object[0]);
        }
        catch (Exception ignore) {
            try {
                Object results = this.execute((Function)new GetRegionsFunction(), new Object[0]);
                List<String> regionNames = Collections.emptyList();
                if (this.containsRegionInformation(results)) {
                    Object[] resultsArray = (Object[])results;
                    regionNames = new ArrayList<String>(resultsArray.length);
                    for (Object result : resultsArray) {
                        regionNames.add(((RegionInformation)result).getName());
                    }
                }
                return regionNames;
            }
            catch (Exception e) {
                this.log("Failed to determine the Regions available on the Server: %n%1$s", e);
                return Collections.emptyList();
            }
        }
    }

    <T> T execute(Function gemfireFunction, Object ... arguments) {
        return (T)new GemfireOnServersFunctionTemplate((RegionService)this.clientCache).executeAndExtract(gemfireFunction, arguments);
    }

    boolean containsRegionInformation(Object results) {
        return results instanceof Object[] && ((Object[])results).length > 0 && ((Object[])results)[0] instanceof RegionInformation;
    }

    void createClientRegionProxies(ConfigurableListableBeanFactory beanFactory, Iterable<String> regionNames) {
        if (regionNames.iterator().hasNext()) {
            ClientRegionFactory clientRegionFactory = this.clientCache.createClientRegionFactory(ClientRegionShortcut.PROXY);
            for (String regionName : regionNames) {
                boolean createRegion = true;
                if (beanFactory.containsBean(regionName)) {
                    Object existingBean = beanFactory.getBean(regionName);
                    Assert.isTrue((boolean)(existingBean instanceof Region), (String)String.format("Cannot create a client PROXY Region bean named '%1$s'. A bean with this name of type '%2$s' already exists.", regionName, ObjectUtils.nullSafeClassName((Object)existingBean)));
                    createRegion = false;
                }
                if (createRegion) {
                    this.log("Creating Region bean with name '%s'...", regionName);
                    beanFactory.registerSingleton(regionName, (Object)clientRegionFactory.create(regionName));
                    continue;
                }
                this.log("A Region with name '%s' is already defined.", regionName);
            }
        }
    }

    void log(String message, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format(message, arguments));
        }
    }
}

