/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.management.internal.cli.util.spring.StringUtils;
import java.io.IOException;
import java.util.List;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GatewayReceiverFactoryBean
extends AbstractWANComponentFactoryBean<GatewayReceiver>
implements SmartLifecycle {
    private boolean manualStart = false;
    private volatile GatewayReceiver gatewayReceiver;
    private Integer endPort;
    private Integer maximumTimeBetweenPings;
    private Integer socketBufferSize;
    private Integer startPort;
    private List<GatewayTransportFilter> transportFilters;
    private String bindAddress;
    private String hostnameForSenders;

    public GatewayReceiverFactoryBean(Cache cache) {
        super(cache);
    }

    @Override
    public GatewayReceiver getObject() throws Exception {
        return this.gatewayReceiver;
    }

    @Override
    public Class<?> getObjectType() {
        return this.gatewayReceiver != null ? this.gatewayReceiver.getClass() : GatewayReceiver.class;
    }

    @Override
    protected void doInit() throws Exception {
        GatewayReceiverFactory gatewayReceiverFactory = this.cache.createGatewayReceiverFactory();
        if (!CollectionUtils.isEmpty(this.transportFilters)) {
            for (GatewayTransportFilter transportFilter : this.transportFilters) {
                gatewayReceiverFactory.addGatewayTransportFilter(transportFilter);
            }
        }
        if (StringUtils.hasText((String)this.bindAddress)) {
            gatewayReceiverFactory.setBindAddress(this.bindAddress);
        }
        if (StringUtils.hasText((String)this.hostnameForSenders)) {
            gatewayReceiverFactory.setHostnameForSenders(this.hostnameForSenders);
        }
        int localStartPort = this.startPort != null ? this.startPort : 5000;
        int localEndPort = this.endPort != null ? this.endPort : 5500;
        Assert.isTrue((localStartPort <= localEndPort ? 1 : 0) != 0, (String)String.format("'startPort' must be less than or equal to %1$d.", localEndPort));
        gatewayReceiverFactory.setStartPort(localStartPort);
        gatewayReceiverFactory.setEndPort(localEndPort);
        if (this.maximumTimeBetweenPings != null) {
            gatewayReceiverFactory.setMaximumTimeBetweenPings(this.maximumTimeBetweenPings.intValue());
        }
        if (this.socketBufferSize != null) {
            gatewayReceiverFactory.setSocketBufferSize(this.socketBufferSize.intValue());
        }
        this.gatewayReceiver = gatewayReceiverFactory.create();
    }

    public void setGatewayReceiver(GatewayReceiver gatewayReceiver) {
        this.gatewayReceiver = gatewayReceiver;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setHostnameForSenders(String hostnameForSenders) {
        this.hostnameForSenders = hostnameForSenders;
    }

    public void setStartPort(Integer startPort) {
        this.startPort = startPort;
    }

    public void setEndPort(Integer endPort) {
        this.endPort = endPort;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = Boolean.TRUE.equals(manualStart);
    }

    public void setMaximumTimeBetweenPings(Integer maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setTransportFilters(List<GatewayTransportFilter> transportFilters) {
        this.transportFilters = transportFilters;
    }

    public boolean isAutoStartup() {
        return !this.manualStart;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isRunning() {
        return this.gatewayReceiver.isRunning();
    }

    public void start() {
        Assert.state((this.gatewayReceiver != null ? 1 : 0) != 0, (String)"The GatewayReceiver was not properly configured and initialized!");
        if (!this.isRunning()) {
            try {
                this.gatewayReceiver.start();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to start Gateway Receiver due to I/O error.", e);
            }
        }
    }

    public void stop() {
        this.gatewayReceiver.stop();
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

