/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.Region;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class GemfirePersistentEntity<T>
extends BasicPersistentEntity<T, GemfirePersistentProperty> {
    private final String regionName;

    public GemfirePersistentEntity(TypeInformation<T> information) {
        super(information);
        Class rawType = information.getType();
        Region region = rawType.getAnnotation(Region.class);
        String fallbackName = rawType.getSimpleName();
        this.regionName = region == null || !StringUtils.hasText((String)region.value()) ? fallbackName : region.value();
    }

    public String getRegionName() {
        return this.regionName;
    }
}

