/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.QueryService;
import java.util.Collection;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.IndexType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class IndexFactoryBean
implements InitializingBean,
FactoryBean<Index>,
BeanNameAware {
    private boolean override = true;
    private Index index;
    private IndexType indexType;
    private QueryService queryService;
    private RegionService cache;
    private String beanName;
    private String expression;
    private String from;
    private String imports;
    private String name;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"The GemFire Cache reference must not be null!");
        this.queryService = this.lookupQueryService();
        Assert.notNull((Object)this.queryService, (String)"A QueryService is required for Index creation!");
        Assert.hasText((String)this.expression, (String)"The Index 'expression' is required!");
        Assert.hasText((String)this.from, (String)"The Index 'from' clause (a Region's full-path) is required!");
        if (IndexType.isKey(this.indexType)) {
            Assert.isNull((Object)this.imports, (String)"The 'imports' property is not supported for a Key Index.");
        }
        String indexName = StringUtils.hasText((String)this.name) ? this.name : this.beanName;
        Assert.hasText((String)indexName, (String)"The Index bean id or name is required!");
        this.index = this.createIndex(this.queryService, indexName);
    }

    QueryService lookupQueryService() {
        return this.queryService != null ? this.queryService : (this.cache instanceof ClientCache ? ((ClientCache)this.cache).getLocalQueryService() : this.cache.getQueryService());
    }

    Index createIndex(QueryService queryService, String indexName) throws Exception {
        Index existingIndex = this.getExistingIndex(queryService, indexName);
        if (existingIndex != null) {
            if (this.override) {
                queryService.removeIndex(existingIndex);
            } else {
                return existingIndex;
            }
        }
        try {
            if (IndexType.isKey(this.indexType)) {
                return queryService.createKeyIndex(indexName, this.expression, this.from);
            }
            if (IndexType.isHash(this.indexType)) {
                return this.createHashIndex(queryService, indexName, this.expression, this.from, this.imports);
            }
            return this.createFunctionalIndex(queryService, indexName, this.expression, this.from, this.imports);
        }
        catch (IndexExistsException e) {
            return this.getExistingIndex(queryService, indexName);
        }
        catch (Exception e) {
            Collection indexes;
            if (existingIndex != null && (CollectionUtils.isEmpty((Collection)(indexes = queryService.getIndexes())) || !indexes.contains(existingIndex))) {
                queryService.getIndexes().add(existingIndex);
                return existingIndex;
            }
            throw e;
        }
    }

    Index createFunctionalIndex(QueryService queryService, String indexName, String expression, String from, String imports) throws Exception {
        if (StringUtils.hasText((String)imports)) {
            return queryService.createIndex(indexName, expression, from, imports);
        }
        return queryService.createIndex(indexName, expression, from);
    }

    Index createHashIndex(QueryService queryService, String indexName, String expression, String from, String imports) throws Exception {
        if (StringUtils.hasText((String)imports)) {
            return queryService.createHashIndex(indexName, expression, from, imports);
        }
        return queryService.createHashIndex(indexName, expression, from);
    }

    Index getExistingIndex(QueryService queryService, String indexName) {
        for (Index index : queryService.getIndexes()) {
            if (!index.getName().equalsIgnoreCase(indexName)) continue;
            return index;
        }
        return null;
    }

    public Index getObject() {
        return this.index;
    }

    public Class<?> getObjectType() {
        return this.index != null ? this.index.getClass() : Index.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCache(RegionService cache) {
        this.cache = cache;
    }

    public void setQueryService(QueryService service) {
        this.queryService = service;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setImports(String imports) {
        this.imports = imports;
    }

    public void setType(String type) {
        this.setType(IndexType.valueOfIgnoreCase(type));
    }

    public void setType(IndexType indexType) {
        this.indexType = indexType;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }
}

