/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import com.gemstone.gemfire.cache.Region;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public class Regions
implements Iterable<Region<?, ?>> {
    private final Map<String, Region<?, ?>> regions;
    private final MappingContext<? extends GemfirePersistentEntity<?>, ?> context;

    public Regions(Iterable<Region<?, ?>> regions, MappingContext<? extends GemfirePersistentEntity<?>, ?> context) {
        Assert.notNull(regions);
        Assert.notNull(context);
        HashMap regionMap = new HashMap();
        for (Region<?, ?> region : regions) {
            regionMap.put(region.getName(), region);
            regionMap.put(region.getFullPath(), region);
        }
        this.regions = Collections.unmodifiableMap(regionMap);
        this.context = context;
    }

    public <T> Region<?, T> getRegion(Class<T> type) {
        Assert.notNull(type);
        GemfirePersistentEntity entity = (GemfirePersistentEntity)this.context.getPersistentEntity(type);
        return entity == null ? this.regions.get(type.getSimpleName()) : this.regions.get(entity.getRegionName());
    }

    public <S, T> Region<S, T> getRegion(String namePath) {
        Assert.notNull((Object)namePath);
        return this.regions.get(namePath);
    }

    @Override
    public Iterator<Region<?, ?>> iterator() {
        return this.regions.values().iterator();
    }
}

