/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.gemfire.function.PojoFunctionWrapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class GemfireFunctionUtils {
    private static Log log = LogFactory.getLog(GemfireFunctionUtils.class);

    public static void registerFunctionForPojoMethod(Object target, Method method, Map<String, Object> attributes, boolean overwrite) {
        boolean hasResult;
        String id = attributes.containsKey("id") ? (String)attributes.get("id") : "";
        PojoFunctionWrapper function = new PojoFunctionWrapper(target, method, id);
        if (attributes.containsKey("HA")) {
            function.setHA((Boolean)attributes.get("HA"));
        }
        if (attributes.containsKey("optimizeForWrite")) {
            function.setOptimizeForWrite((Boolean)attributes.get("optimizeForWrite"));
        }
        if (attributes.containsKey("batchSize")) {
            int batchSize = (Integer)attributes.get("batchSize");
            Assert.isTrue((batchSize >= 0 ? 1 : 0) != 0, (String)String.format("batchSize must be a non-negative value %s.%s", target.getClass().getName(), method.getName()));
            function.setBatchSize(batchSize);
        }
        if (attributes.containsKey("hasResult") && (hasResult = ((Boolean)attributes.get("hasResult")).booleanValue())) {
            function.setHasResult(hasResult);
        }
        if (FunctionService.isRegistered((String)function.getId()) && overwrite) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("unregistering function definition " + function.getId()));
            }
            FunctionService.unregisterFunction((String)function.getId());
        }
        if (!FunctionService.isRegistered((String)function.getId())) {
            FunctionService.registerFunction((Function)function);
            if (log.isDebugEnabled()) {
                log.debug((Object)("registered function " + function.getId()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("function " + function.getId() + "is already registered"));
        }
    }

    public static int getAnnotationParameterPosition(Method method, Class<?> targetAnnotationType, Class<?>[] requiredTypes) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length > 0) {
            int position = -1;
            Class<?>[] paramTypes = method.getParameterTypes();
            List<Class<?>> requiredTypesList = Arrays.asList(requiredTypes);
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] annotations = parameterAnnotations[i];
                if (annotations.length <= 0) continue;
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(targetAnnotationType)) continue;
                    Assert.state((position < 0 ? 1 : 0) != 0, (String)String.format("Method %s signature cannot contain more than one parameter annotated with type %s", method.getName(), targetAnnotationType.getName()));
                    boolean isRequiredType = false;
                    for (Class<?> requiredType : requiredTypesList) {
                        if (!requiredType.isAssignableFrom(paramTypes[i])) continue;
                        isRequiredType = true;
                        break;
                    }
                    Assert.isTrue((boolean)isRequiredType, (String)String.format("Parameter of type %s annotated with %s must be assignable from one of type %s in method %s", paramTypes[i], targetAnnotationType.getName(), StringUtils.arrayToCommaDelimitedString((Object[])requiredTypes), method.getName()));
                    position = i;
                }
            }
            return position;
        }
        return -1;
    }
}

