/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.config.EvictionType;

class EvictionAttributesFactoryBean
implements FactoryBean<EvictionAttributes>,
InitializingBean {
    protected static final int DEFAULT_LRU_MAXIMUM_ENTRIES = 900;
    protected static final int DEFAULT_MEMORY_MAXIMUM_SIZE = 10;
    private EvictionAction action = null;
    private EvictionAttributes evictionAttributes;
    private EvictionType type = EvictionType.ENTRY_COUNT;
    private Integer threshold = null;
    private ObjectSizer objectSizer = null;

    EvictionAttributesFactoryBean() {
    }

    public void afterPropertiesSet() {
        this.action = this.action != null ? this.action : EvictionAction.DEFAULT_EVICTION_ACTION;
        this.evictionAttributes = this.createAttributes();
    }

    EvictionAttributes createAttributes() {
        switch (this.type) {
            case HEAP_PERCENTAGE: {
                if (this.threshold != null) {
                    throw new IllegalArgumentException("The HEAP_PERCENTAGE (LRU_HEAP algorithm) does not support threshold (a.k.a. maximum)!");
                }
                return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)this.objectSizer, (EvictionAction)this.action);
            }
            case MEMORY_SIZE: {
                return this.threshold != null ? EvictionAttributes.createLRUMemoryAttributes((int)this.threshold, (ObjectSizer)this.objectSizer, (EvictionAction)this.action) : EvictionAttributes.createLRUMemoryAttributes((ObjectSizer)this.objectSizer, (EvictionAction)this.action);
            }
        }
        return this.threshold != null ? EvictionAttributes.createLRUEntryAttributes((int)this.threshold, (EvictionAction)this.action) : EvictionAttributes.createLRUEntryAttributes((int)900, (EvictionAction)this.action);
    }

    public EvictionAttributes getObject() {
        return this.evictionAttributes;
    }

    public Class<?> getObjectType() {
        return this.evictionAttributes != null ? this.evictionAttributes.getClass() : EvictionAttributes.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public EvictionAction getAction() {
        return this.action;
    }

    public void setAction(EvictionAction action) {
        this.action = action;
    }

    public ObjectSizer getObjectSizer() {
        return this.objectSizer;
    }

    public void setObjectSizer(ObjectSizer objectSizer) {
        this.objectSizer = objectSizer;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public EvictionType getType() {
        return this.type;
    }

    public void setType(EvictionType type) {
        this.type = type;
    }
}

