/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.DiskStoreFactoryBean;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DiskStoreParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return DiskStoreFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.setLazyInit(false);
        ParsingUtils.setPropertyReference(element, builder, "cache-ref", "cache");
        ParsingUtils.setPropertyValue(element, builder, "allow-force-compaction");
        ParsingUtils.setPropertyValue(element, builder, "auto-compact");
        ParsingUtils.setPropertyValue(element, builder, "compaction-threshold");
        ParsingUtils.setPropertyValue(element, builder, "max-oplog-size");
        ParsingUtils.setPropertyValue(element, builder, "queue-size");
        ParsingUtils.setPropertyValue(element, builder, "time-interval");
        ParsingUtils.setPropertyValue(element, builder, "write-buffer-size");
        List diskDirElements = DomUtils.getChildElementsByTagName((Element)element, (String)"disk-dir");
        if (!CollectionUtils.isEmpty((Collection)diskDirElements)) {
            ManagedList diskDirs = new ManagedList();
            for (Element diskDirElement : diskDirElements) {
                BeanDefinitionBuilder diskDirBuilder = BeanDefinitionBuilder.genericBeanDefinition(DiskStoreFactoryBean.DiskDir.class);
                diskDirBuilder.addConstructorArgValue((Object)diskDirElement.getAttribute("location"));
                if (diskDirElement.hasAttribute("max-size")) {
                    diskDirBuilder.addConstructorArgValue((Object)diskDirElement.getAttribute("max-size"));
                }
                diskDirs.add((Object)diskDirBuilder.getBeanDefinition());
            }
            builder.addPropertyValue("diskDirs", (Object)diskDirs);
        }
    }
}

