/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.FixedPartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.config.AbstractRegionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PartitionedRegionParser
extends AbstractRegionParser {
    PartitionedRegionParser() {
    }

    @Override
    protected Class<?> getRegionFactoryClass() {
        return PartitionedRegionFactoryBean.class;
    }

    @Override
    protected void doParseRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, boolean subRegion) {
        List fixedPartitions;
        super.doParse(element, builder);
        BeanDefinitionBuilder regionAttributesBuilder = subRegion ? builder : BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        super.doParseCommonRegionConfiguration(element, parserContext, builder, regionAttributesBuilder, subRegion);
        BeanDefinitionBuilder partitionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(PartitionAttributesFactoryBean.class);
        this.parseColocatedWith(element, builder, partitionAttributesBuilder, "colocated-with");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "local-max-memory");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "copies", "redundantCopies");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "recovery-delay");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "startup-recovery-delay");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "total-max-memory");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "total-buckets", "totalNumBuckets");
        Element subElement = DomUtils.getChildElementByTagName((Element)element, (String)"partition-resolver");
        if (subElement != null) {
            partitionAttributesBuilder.addPropertyValue("partitionResolver", this.parsePartitionResolver(parserContext, subElement, builder));
        }
        if ((subElement = DomUtils.getChildElementByTagName((Element)element, (String)"partition-listener")) != null) {
            partitionAttributesBuilder.addPropertyValue("partitionListeners", this.parsePartitionListeners(parserContext, subElement, builder));
        }
        if (!CollectionUtils.isEmpty((Collection)(fixedPartitions = DomUtils.getChildElementsByTagName((Element)element, (String)"fixed-partition")))) {
            ManagedList fixedPartitionAttributes = new ManagedList();
            for (Element fp : fixedPartitions) {
                BeanDefinitionBuilder fpaBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixedPartitionAttributesFactoryBean.class);
                ParsingUtils.setPropertyValue(fp, fpaBuilder, "partition-name");
                ParsingUtils.setPropertyValue(fp, fpaBuilder, "num-buckets");
                ParsingUtils.setPropertyValue(fp, fpaBuilder, "primary");
                fixedPartitionAttributes.add((Object)fpaBuilder.getBeanDefinition());
            }
            partitionAttributesBuilder.addPropertyValue("fixedPartitionAttributes", (Object)fixedPartitionAttributes);
        }
        regionAttributesBuilder.addPropertyValue("partitionAttributes", (Object)partitionAttributesBuilder.getBeanDefinition());
        if (!subRegion) {
            builder.addPropertyValue("attributes", (Object)regionAttributesBuilder.getBeanDefinition());
        }
    }

    private void parseColocatedWith(Element element, BeanDefinitionBuilder regionBuilder, BeanDefinitionBuilder partitionAttributesBuilder, String attributeName) {
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, attributeName);
        String colocatedWithBeanAlias = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)colocatedWithBeanAlias)) {
            regionBuilder.addDependsOn(colocatedWithBeanAlias);
        }
    }

    private Object parsePartitionResolver(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parsePartitionListeners(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }
}

