/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.config.EvictionAttributesFactoryBean;
import org.springframework.data.gemfire.config.EvictionType;
import org.springframework.data.gemfire.config.SubscriptionAttributesFactoryBean;
import org.springframework.data.gemfire.config.SubscriptionType;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class ParsingUtils {
    private static final Log log = LogFactory.getLog(ParsingUtils.class);

    ParsingUtils() {
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName, String propertyName, Object defaultValue) {
        String attr = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue(propertyName, (Object)attr);
        } else if (defaultValue != null) {
            builder.addPropertyValue(propertyName, defaultValue);
        }
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName, String propertyName) {
        ParsingUtils.setPropertyValue(element, builder, attributeName, propertyName, null);
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName) {
        ParsingUtils.setPropertyValue(element, builder, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    static void setPropertyReference(Element element, BeanDefinitionBuilder builder, String attrName, String propertyName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyReference(propertyName, attr);
        }
    }

    static Object parseRefOrNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, element, builder, "ref", false);
    }

    static Object getBeanReference(ParserContext parserContext, Element element, String refAttributeName) {
        String refAttributeValue = element.getAttribute(refAttributeName);
        List childElements = DomUtils.getChildElements((Element)element);
        if (StringUtils.hasText((String)refAttributeValue)) {
            if (!childElements.isEmpty()) {
                parserContext.getReaderContext().error(String.format("Use either the '%1$s' attribute or a nested bean declaration for '%2$s' element, but not both", refAttributeName, element.getLocalName()), (Object)element);
            }
            return new RuntimeBeanReference(refAttributeValue);
        }
        return null;
    }

    static Object parseRefOrNestedCustomElement(ParserContext parserContext, Element element, BeanDefinitionBuilder builder) {
        Object beanRef = ParsingUtils.getBeanReference(parserContext, element, "bean");
        if (beanRef != null) {
            return beanRef;
        }
        return parserContext.getDelegate().parseCustomElement(element, (BeanDefinition)builder.getBeanDefinition());
    }

    static Object parseRefOrSingleNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, element, builder, "ref", true);
    }

    static Object parseRefOrNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder, String refAttributeName) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, element, builder, refAttributeName, false);
    }

    static Object parseRefOrNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder, String refAttributeName, boolean single) {
        Object beanReference = ParsingUtils.getBeanReference(parserContext, element, refAttributeName);
        if (beanReference != null) {
            return beanReference;
        }
        List childElements = DomUtils.getChildElements((Element)element);
        if (childElements.size() == 1) {
            return parserContext.getDelegate().parsePropertySubElement((Element)childElements.get(0), (BeanDefinition)builder.getRawBeanDefinition());
        }
        if (single) {
            parserContext.getReaderContext().error(String.format("The element '%1$s' does not support multiple nested bean definitions", element.getLocalName()), (Object)element);
        }
        ManagedList list = new ManagedList();
        for (Element childElement : childElements) {
            list.add(parserContext.getDelegate().parsePropertySubElement(childElement, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        return list;
    }

    static boolean parseEviction(ParserContext parserContext, Element element, BeanDefinitionBuilder attributesBuilder) {
        Element evictionElement = DomUtils.getChildElementByTagName((Element)element, (String)"eviction");
        if (evictionElement != null) {
            Element objectSizerElement;
            BeanDefinitionBuilder evictionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvictionAttributesFactoryBean.class);
            ParsingUtils.setPropertyValue(evictionElement, evictionAttributesBuilder, "action");
            ParsingUtils.setPropertyValue(evictionElement, evictionAttributesBuilder, "threshold");
            String evictionType = evictionElement.getAttribute("type");
            if (StringUtils.hasText((String)evictionType)) {
                evictionAttributesBuilder.addPropertyValue("type", (Object)EvictionType.valueOf(evictionType.toUpperCase()));
            }
            if ((objectSizerElement = DomUtils.getChildElementByTagName((Element)evictionElement, (String)"object-sizer")) != null) {
                Object sizer = ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, objectSizerElement, evictionAttributesBuilder);
                evictionAttributesBuilder.addPropertyValue("ObjectSizer", sizer);
            }
            attributesBuilder.addPropertyValue("evictionAttributes", (Object)evictionAttributesBuilder.getBeanDefinition());
            return true;
        }
        return false;
    }

    static boolean parseSubscription(ParserContext parserContext, Element element, BeanDefinitionBuilder attrBuilder) {
        Element subscriptionElement = DomUtils.getChildElementByTagName((Element)element, (String)"subscription");
        if (subscriptionElement == null) {
            return false;
        }
        BeanDefinitionBuilder subscriptionDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(SubscriptionAttributesFactoryBean.class);
        String attr = subscriptionElement.getAttribute("type");
        if (StringUtils.hasText((String)attr)) {
            subscriptionDefBuilder.addPropertyValue("type", (Object)SubscriptionType.valueOf(attr.toUpperCase()));
        }
        attrBuilder.addPropertyValue("subscriptionAttributes", (Object)subscriptionDefBuilder.getBeanDefinition());
        return true;
    }

    static void parseTransportFilters(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element transportFilterElement = DomUtils.getChildElementByTagName((Element)element, (String)"transport-filter");
        if (transportFilterElement != null) {
            builder.addPropertyValue("transportFilters", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, transportFilterElement, builder));
        }
    }

    static void parseStatistics(Element element, BeanDefinitionBuilder attrBuilder) {
        ParsingUtils.setPropertyValue(element, attrBuilder, "statistics", "statisticsEnabled");
    }

    static boolean parseExpiration(ParserContext parserContext, Element element, BeanDefinitionBuilder attrBuilder) {
        boolean result = ParsingUtils.parseExpiration(element, "region-ttl", "regionTimeToLive", attrBuilder);
        result |= ParsingUtils.parseExpiration(element, "region-tti", "regionIdleTimeout", attrBuilder);
        result |= ParsingUtils.parseExpiration(element, "entry-ttl", "entryTimeToLive", attrBuilder);
        result |= ParsingUtils.parseExpiration(element, "entry-tti", "entryIdleTimeout", attrBuilder);
        result |= ParsingUtils.parseCustomExpiration(parserContext, element, "custom-entry-ttl", "customEntryTimeToLive", attrBuilder);
        if (result |= ParsingUtils.parseCustomExpiration(parserContext, element, "custom-entry-tti", "customEntryIdleTimeout", attrBuilder)) {
            attrBuilder.addPropertyValue("statisticsEnabled", (Object)Boolean.TRUE);
        }
        return result;
    }

    static void parseOptionalRegionAttributes(ParserContext parserContext, Element element, BeanDefinitionBuilder attrBuilder) {
        String concurrencyChecksEnabled;
        if (!"partitioned-region".equals(element.getLocalName())) {
            ParsingUtils.setPropertyValue(element, attrBuilder, "persistent", "persistBackup");
        }
        ParsingUtils.setPropertyValue(element, attrBuilder, "ignore-jta", "ignoreJTA");
        ParsingUtils.setPropertyValue(element, attrBuilder, "key-constraint");
        ParsingUtils.setPropertyValue(element, attrBuilder, "value-constraint");
        ParsingUtils.setPropertyValue(element, attrBuilder, "is-lock-grantor", "lockGrantor");
        ParsingUtils.setPropertyValue(element, attrBuilder, "enable-subscription-conflation");
        ParsingUtils.setPropertyValue(element, attrBuilder, "enable-async-conflation");
        ParsingUtils.setPropertyValue(element, attrBuilder, "initial-capacity");
        ParsingUtils.setPropertyValue(element, attrBuilder, "load-factor");
        ParsingUtils.setPropertyValue(element, attrBuilder, "cloning-enabled");
        ParsingUtils.setPropertyValue(element, attrBuilder, "concurrency-level");
        ParsingUtils.setPropertyValue(element, attrBuilder, "multicast-enabled");
        String indexUpdateType = element.getAttribute("index-update-type");
        if (StringUtils.hasText((String)indexUpdateType)) {
            attrBuilder.addPropertyValue("indexMaintenanceSynchronous", (Object)"synchronous".equals(indexUpdateType));
        }
        if (StringUtils.hasText((String)(concurrencyChecksEnabled = element.getAttribute("concurrency-checks-enabled")))) {
            if (!GemfireUtils.isGemfireVersion7OrAbove()) {
                log.warn((Object)"'concurrency-checks-enabled' is only available in Gemfire 7.0 or above");
            } else {
                ParsingUtils.setPropertyValue(element, attrBuilder, "concurrency-checks-enabled");
            }
        }
    }

    static void parseMembershipAttributes(ParserContext parserContext, Element element, BeanDefinitionBuilder attrBuilder) {
        Element membershipAttributes = DomUtils.getChildElementByTagName((Element)element, (String)"membership-attributes");
        if (membershipAttributes != null) {
            String[] requiredRoles = StringUtils.commaDelimitedListToStringArray((String)membershipAttributes.getAttribute("required-roles"));
            String lossActionAttr = membershipAttributes.getAttribute("loss-action");
            LossAction lossAction = StringUtils.hasText((String)lossActionAttr) ? LossAction.fromName((String)lossActionAttr.toUpperCase().replace("-", "_")) : null;
            String resumptionActionAttr = membershipAttributes.getAttribute("resumption-action");
            ResumptionAction resumptionAction = StringUtils.hasText((String)resumptionActionAttr) ? ResumptionAction.fromName((String)resumptionActionAttr.toUpperCase().replace("-", "_")) : null;
            ManagedArray requiredRolesArray = new ManagedArray("java.lang.String", requiredRoles.length);
            for (int i = 0; i < requiredRoles.length; ++i) {
                requiredRolesArray.add((Object)requiredRoles[i]);
            }
            BeanDefinitionBuilder membershipAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(MembershipAttributes.class);
            membershipAttributesBuilder.addConstructorArgValue((Object)requiredRolesArray);
            membershipAttributesBuilder.addConstructorArgValue((Object)lossAction);
            membershipAttributesBuilder.addConstructorArgValue((Object)resumptionAction);
            attrBuilder.addPropertyValue("membershipAttributes", (Object)membershipAttributesBuilder.getRawBeanDefinition());
        }
    }

    static void throwExceptionIfNotGemfireV7(String elementName, String attributeName, ParserContext parserContext) {
        if (!GemfireUtils.isGemfireVersion7OrAbove()) {
            String messagePrefix = attributeName == null ? "element '" + elementName + "'" : "attribute '" + attributeName + " of element '" + elementName + "'";
            parserContext.getReaderContext().error(messagePrefix + " requires Gemfire version 7 or later. The current version is " + GemfireUtils.GEMFIRE_VERSION, null);
        }
    }

    static void parseScope(Element element, BeanDefinitionBuilder builder) {
        String scope = element.getAttribute("scope");
        if (StringUtils.hasText((String)scope)) {
            builder.addPropertyValue("scope", (Object)Scope.fromString((String)scope.toUpperCase().replace("-", "_")));
        } else {
            builder.addPropertyValue("scope", (Object)Scope.DISTRIBUTED_ACK);
        }
    }

    private static boolean parseExpiration(Element rootElement, String elementName, String propertyName, BeanDefinitionBuilder attrBuilder) {
        Element expirationElement = DomUtils.getChildElementByTagName((Element)rootElement, (String)elementName);
        if (expirationElement == null) {
            return false;
        }
        String expirationTime = null;
        ExpirationAction action = ExpirationAction.INVALIDATE;
        String attr = expirationElement.getAttribute("timeout");
        if (StringUtils.hasText((String)attr)) {
            expirationTime = attr;
        }
        if (StringUtils.hasText((String)(attr = expirationElement.getAttribute("action")))) {
            if ((attr = attr.trim()).length() == 10) {
                action = ExpirationAction.INVALIDATE;
            } else if (attr.length() == 7) {
                action = ExpirationAction.DESTROY;
            } else if (attr.length() == 13) {
                action = ExpirationAction.LOCAL_DESTROY;
            } else if (attr.length() == 16) {
                action = ExpirationAction.LOCAL_INVALIDATE;
            }
        }
        BeanDefinitionBuilder expirationAttributes = BeanDefinitionBuilder.genericBeanDefinition(ExpirationAttributes.class);
        expirationAttributes.addConstructorArgValue((Object)expirationTime);
        expirationAttributes.addConstructorArgValue((Object)action);
        attrBuilder.addPropertyValue(propertyName, (Object)expirationAttributes.getBeanDefinition());
        return true;
    }

    private static boolean parseCustomExpiration(ParserContext parserContext, Element rootElement, String elementName, String propertyName, BeanDefinitionBuilder attrBuilder) {
        Element expirationElement = DomUtils.getChildElementByTagName((Element)rootElement, (String)elementName);
        if (expirationElement == null) {
            return false;
        }
        Object customExpiry = ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, expirationElement, attrBuilder);
        attrBuilder.addPropertyValue(propertyName, customExpiry);
        return true;
    }
}

