/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.client.RegexInterest;
import org.springframework.data.gemfire.config.AbstractRegionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ClientRegionParser
extends AbstractRegionParser {
    ClientRegionParser() {
    }

    @Override
    protected Class<?> getRegionFactoryClass() {
        return ClientRegionFactoryBean.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        this.validateDataPolicyShortcutMutualExclusion(element, parserContext);
        String cacheRefAttributeValue = element.getAttribute("cache-ref");
        builder.addPropertyReference("cache", StringUtils.hasText((String)cacheRefAttributeValue) ? cacheRefAttributeValue : "gemfireCache");
        ParsingUtils.setPropertyValue(element, builder, "close");
        ParsingUtils.setPropertyValue(element, builder, "destroy");
        ParsingUtils.setPropertyValue(element, builder, "data-policy", "dataPolicyName");
        ParsingUtils.setPropertyValue(element, builder, "name");
        ParsingUtils.setPropertyValue(element, builder, "persistent");
        ParsingUtils.setPropertyValue(element, builder, "pool-name");
        ParsingUtils.setPropertyValue(element, builder, "shortcut");
        this.parseDiskStoreAttribute(element, builder);
        BeanDefinitionBuilder regionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        ParsingUtils.parseOptionalRegionAttributes(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseStatistics(element, regionAttributesBuilder);
        ParsingUtils.parseEviction(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseExpiration(parserContext, element, regionAttributesBuilder);
        builder.addPropertyValue("attributes", (Object)regionAttributesBuilder.getBeanDefinition());
        List subElements = DomUtils.getChildElements((Element)element);
        ManagedList interests = new ManagedList();
        for (Element subElement : subElements) {
            String subElementLocalName = subElement.getLocalName();
            if ("cache-listener".equals(subElementLocalName)) {
                builder.addPropertyValue("cacheListeners", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
                continue;
            }
            if ("cache-loader".equals(subElementLocalName)) {
                builder.addPropertyValue("cacheLoader", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
                continue;
            }
            if ("cache-writer".equals(subElementLocalName)) {
                builder.addPropertyValue("cacheWriter", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
                continue;
            }
            if ("key-interest".equals(subElementLocalName)) {
                interests.add(this.parseKeyInterest(subElement, parserContext));
                continue;
            }
            if (!"regex-interest".equals(subElementLocalName)) continue;
            interests.add(this.parseRegexInterest(subElement));
        }
        if (!interests.isEmpty()) {
            builder.addPropertyValue("interests", (Object)interests);
        }
    }

    @Override
    protected void doParseRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, boolean subRegion) {
        throw new UnsupportedOperationException(String.format("doParseRegion(:Element, :ParserContext, :BeanDefinitionBuilder, :boolean) is not supported on %1$s", ((Object)((Object)this)).getClass().getName()));
    }

    private void validateDataPolicyShortcutMutualExclusion(Element element, ParserContext parserContext) {
        if (element.hasAttribute("data-policy") && element.hasAttribute("shortcut")) {
            parserContext.getReaderContext().error(String.format("Only one of [data-policy, shortcut] may be specified with element '%1$s'.", element.getTagName()), (Object)element);
        }
    }

    private void parseDiskStoreAttribute(Element element, BeanDefinitionBuilder builder) {
        String diskStoreRefAttribute = element.getAttribute("disk-store-ref");
        if (StringUtils.hasText((String)diskStoreRefAttribute)) {
            builder.addPropertyValue("diskStoreName", (Object)diskStoreRefAttribute);
            builder.addDependsOn(diskStoreRefAttribute);
        }
    }

    private Object parseKeyInterest(Element keyInterestElement, ParserContext parserContext) {
        BeanDefinitionBuilder keyInterestBuilder = BeanDefinitionBuilder.genericBeanDefinition(Interest.class);
        this.parseCommonInterestAttributes(keyInterestElement, keyInterestBuilder);
        keyInterestBuilder.addConstructorArgValue(ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, keyInterestElement, keyInterestBuilder, "key-ref"));
        return keyInterestBuilder.getBeanDefinition();
    }

    private Object parseRegexInterest(Element regexInterestElement) {
        BeanDefinitionBuilder regexInterestBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegexInterest.class);
        this.parseCommonInterestAttributes(regexInterestElement, regexInterestBuilder);
        ParsingUtils.setPropertyValue(regexInterestElement, regexInterestBuilder, "pattern", "key");
        return regexInterestBuilder.getBeanDefinition();
    }

    private void parseCommonInterestAttributes(Element element, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "durable", "durable");
        ParsingUtils.setPropertyValue(element, builder, "result-policy", "policy");
        ParsingUtils.setPropertyValue(element, builder, "receive-values", "receiveValues");
    }
}

