/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class RegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements DisposableBean,
SmartLifecycle {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean autoStartup = true;
    private boolean close = true;
    private boolean destroy = false;
    private boolean running;
    private Boolean enableGateway;
    private Boolean persistent;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private Object[] asyncEventQueues;
    private Object[] gatewaySenders;
    private RegionAttributes<K, V> attributes;
    private Resource snapshot;
    private Scope scope;
    private String dataPolicy;
    private String diskStoreName;
    private String hubId;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.postProcess(this.getRegion());
    }

    @Override
    protected Region<K, V> lookupFallback(GemFireCache gemfireCache, String regionName) throws Exception {
        RegionFactory regionFactory;
        Assert.isTrue((boolean)(gemfireCache instanceof Cache), (String)("Unable to create Regions from " + gemfireCache));
        Cache cache = (Cache)gemfireCache;
        if (this.attributes != null) {
            AttributesFactory.validateAttributes(this.attributes);
        }
        RegionFactory regionFactory2 = regionFactory = this.attributes != null ? cache.createRegionFactory(this.attributes) : cache.createRegionFactory();
        if (this.hubId != null) {
            this.enableGateway = this.enableGateway == null ? true : this.enableGateway;
            Assert.isTrue((boolean)this.enableGateway, (String)"hubId requires the enableGateway property to be true");
            regionFactory.setGatewayHubId(this.hubId);
        }
        if (this.enableGateway != null) {
            if (this.enableGateway.booleanValue()) {
                Assert.notNull((Object)this.hubId, (String)"enableGateway requires the hubId property to be true");
            }
            regionFactory.setEnableGateway(this.enableGateway.booleanValue());
        }
        if (!ObjectUtils.isEmpty((Object[])this.cacheListeners)) {
            for (CacheListener<K, V> cacheListener : this.cacheListeners) {
                regionFactory.addCacheListener(cacheListener);
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            Assert.isTrue((this.hubId == null ? 1 : 0) != 0, (String)"It is invalid to configure a region with both a hubId and gatewaySenders. Note that the enableGateway and hubId properties are deprecated since Gemfire 7.0");
            for (Object object : this.gatewaySenders) {
                regionFactory.addGatewaySenderId(((GatewaySender)object).getId());
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.asyncEventQueues)) {
            for (Object object : this.asyncEventQueues) {
                regionFactory.addAsyncEventQueueId(((AsyncEventQueue)object).getId());
            }
        }
        if (this.cacheLoader != null) {
            regionFactory.setCacheLoader(this.cacheLoader);
        }
        if (this.cacheWriter != null) {
            regionFactory.setCacheWriter(this.cacheWriter);
        }
        if (this.diskStoreName != null) {
            regionFactory.setDiskStoreName(this.diskStoreName);
        }
        this.resolveDataPolicy(regionFactory, this.persistent, this.dataPolicy);
        if (this.scope != null) {
            regionFactory.setScope(this.scope);
        }
        if (this.attributes != null) {
            Assert.state((!this.attributes.isLockGrantor() || this.scope.isGlobal() ? 1 : 0) != 0, (String)"Lock grantor only applies to a global scoped region");
        }
        this.postProcess(this.findAttrFactory(regionFactory));
        Region region = regionFactory.create(regionName);
        this.log.info((Object)("Created new cache region [" + regionName + "]"));
        if (this.snapshot != null) {
            region.loadSnapshot(this.snapshot.getInputStream());
        }
        if (this.attributes != null && this.attributes.isLockGrantor()) {
            region.becomeLockGrantor();
        }
        return region;
    }

    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        if (dataPolicy != null) {
            DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicy));
            this.assertDataPolicyAndPersistentAttributesAreCompatible(resolvedDataPolicy);
            regionFactory.setDataPolicy(resolvedDataPolicy);
        } else {
            regionFactory.setDataPolicy(this.isPersistent() ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.DEFAULT);
        }
    }

    private AttributesFactory<K, V> findAttrFactory(RegionFactory<K, V> regionFactory) {
        Field attrsFactoryField = ReflectionUtils.findField(RegionFactory.class, (String)"attrsFactory", AttributesFactory.class);
        ReflectionUtils.makeAccessible((Field)attrsFactoryField);
        return (AttributesFactory)ReflectionUtils.getField((Field)attrsFactoryField, regionFactory);
    }

    @Deprecated
    protected void postProcess(AttributesFactory<K, V> attrFactory) {
    }

    protected void postProcess(Region<K, V> region) {
    }

    public void destroy() throws Exception {
        if (this.getRegion() != null) {
            if (this.close && !this.getRegion().getRegionService().isClosed()) {
                try {
                    this.getRegion().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.destroy) {
                this.getRegion().destroyRegion();
            }
        }
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
    }

    public void setSnapshot(Resource snapshot) {
        this.snapshot = snapshot;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setDataPolicy(String dataPolicyName) {
        this.dataPolicy = dataPolicyName;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public void setGatewaySenders(Object[] gatewaySenders) {
        this.gatewaySenders = gatewaySenders;
    }

    public void setAsyncEventQueues(Object[] asyncEventQueues) {
        this.asyncEventQueues = asyncEventQueues;
    }

    public void setEnableGateway(boolean enableGateway) {
        this.enableGateway = enableGateway;
    }

    public void setHubId(String hubId) {
        this.hubId = hubId;
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }

    protected void assertDataPolicyAndPersistentAttributesAreCompatible(DataPolicy resolvedDataPolicy) {
        boolean persistentNotSpecified;
        boolean bl = persistentNotSpecified = this.persistent == null;
        if (resolvedDataPolicy.withPersistence()) {
            Assert.isTrue((persistentNotSpecified || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy '%1$s' is invalid when persistent is false.", resolvedDataPolicy));
        } else {
            Assert.isTrue((persistentNotSpecified || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy '%1$s' is invalid when persistent is true.", resolvedDataPolicy));
        }
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    protected boolean isNotPersistent() {
        return Boolean.FALSE.equals(this.persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start() {
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            Object[] objectArray = this.gatewaySenders;
            // MONITORENTER : this.gatewaySenders
            for (Object obj : this.gatewaySenders) {
                GatewaySender gws = (GatewaySender)obj;
                if (gws.isManualStart() || gws.isRunning()) continue;
                gws.start();
            }
            // MONITOREXIT : objectArray
        }
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() {
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            Object[] objectArray = this.gatewaySenders;
            // MONITORENTER : this.gatewaySenders
            for (Object obj : this.gatewaySenders) {
                ((GatewaySender)obj).stop();
            }
            // MONITOREXIT : objectArray
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

