/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LocalRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V> {
    @Override
    public void setScope(Scope scope) {
        throw new UnsupportedOperationException("Setting the Scope on Local Regions is not allowed.");
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.setScope(Scope.LOCAL);
        super.afterPropertiesSet();
    }

    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
        Assert.isTrue((resolvedDataPolicy != null || !StringUtils.hasText((String)dataPolicy) ? 1 : 0) != 0, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicy));
        if (resolvedDataPolicy == null || DataPolicy.NORMAL.equals(resolvedDataPolicy)) {
            regionFactory.setDataPolicy(this.isPersistent() ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.NORMAL);
        } else if (DataPolicy.PRELOADED.equals(resolvedDataPolicy)) {
            regionFactory.setDataPolicy(this.isPersistent() ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.PRELOADED);
        } else {
            throw new IllegalArgumentException(String.format("Data Policy '%1$s' is not supported in Local Regions.", dataPolicy));
        }
    }
}

