/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class Wrapper<T, KEY extends Serializable> {
    private final KEY key;
    private final T entity;

    public Wrapper(T entity, KEY key) {
        Assert.notNull(key);
        this.entity = entity;
        this.key = key;
    }

    public KEY getKey() {
        return this.key;
    }

    public T getEntity() {
        return this.entity;
    }

    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (!(value instanceof Wrapper)) {
            return false;
        }
        Wrapper that = (Wrapper)value;
        return this.key.equals(that.key) && ObjectUtils.nullSafeEquals(this.entity, that.entity);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.key.hashCode();
        return result += 31 * ObjectUtils.nullSafeHashCode(this.entity);
    }
}

