/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RegionLookupFactoryBean<K, V>
implements FactoryBean<Region<K, V>>,
InitializingBean,
BeanNameAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String beanName;
    private GemFireCache cache;
    private String name;
    private Region<K, V> region;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"Cache property must be set");
        this.name = !StringUtils.hasText((String)this.name) ? this.beanName : this.name;
        Assert.hasText((String)this.name, (String)"Name (or beanName) property must be set");
        GemFireCache gemFireCache = this.cache;
        synchronized (gemFireCache) {
            this.region = this.cache.getRegion(this.name);
            if (this.region != null) {
                this.log.info((Object)("Retrieved region [" + this.name + "] from cache"));
            } else {
                this.region = this.lookupFallback(this.cache, this.name);
            }
        }
    }

    protected Region<K, V> lookupFallback(GemFireCache cache, String regionName) throws Exception {
        throw new BeanInitializationException("Cannot find region [" + regionName + "] in cache " + cache);
    }

    public Region<K, V> getObject() throws Exception {
        return this.region;
    }

    public Class<?> getObjectType() {
        return this.region != null ? this.region.getClass() : Region.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected Region<K, V> getRegion() {
        return this.region;
    }
}

