/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.util.Assert;

public class LocalRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V> {
    @Override
    public void setScope(Scope scope) {
        throw new UnsupportedOperationException("setScope() is not allowed for Local Regions");
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.setScope(Scope.LOCAL);
        super.afterPropertiesSet();
    }

    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        if (dataPolicy != null) {
            if ("NORMAL".equals(dataPolicy = dataPolicy.toUpperCase()) || dataPolicy == null) {
                regionFactory.setDataPolicy(DataPolicy.NORMAL);
            } else if ("PRELOADED".equals(dataPolicy)) {
                regionFactory.setDataPolicy(DataPolicy.PRELOADED);
            } else if ("EMPTY".equals(dataPolicy)) {
                Assert.isTrue((persistent == null || persistent == false ? 1 : 0) != 0, (String)"Cannot have persistence on an empty region");
                regionFactory.setDataPolicy(DataPolicy.EMPTY);
            } else {
                throw new IllegalArgumentException("Data policy '" + dataPolicy + "' is unsupported or invalid for local regions.");
            }
        }
    }
}

