/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.wan.GatewaySenderFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class GatewaySenderParser
extends AbstractSimpleBeanDefinitionParser {
    GatewaySenderParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return GatewaySenderFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String cacheRef = element.getAttribute("cache-ref");
        builder.addConstructorArgReference(StringUtils.hasText((String)cacheRef) ? cacheRef : "gemfireCache");
        ParsingUtils.setPropertyValue(element, builder, "alert-threshold");
        ParsingUtils.setPropertyValue(element, builder, "batch-size");
        ParsingUtils.setPropertyValue(element, builder, "batch-time-interval");
        ParsingUtils.setPropertyValue(element, builder, "disk-store-ref");
        ParsingUtils.setPropertyValue(element, builder, "disk-synchronous");
        ParsingUtils.setPropertyValue(element, builder, "dispatcher-threads");
        ParsingUtils.setPropertyValue(element, builder, "enable-batch-conflation");
        ParsingUtils.setPropertyValue(element, builder, "manual-start");
        ParsingUtils.setPropertyValue(element, builder, "maximum-queue-memory");
        ParsingUtils.setPropertyValue(element, builder, "order-policy");
        ParsingUtils.setPropertyValue(element, builder, "remote-distributed-system-id");
        ParsingUtils.setPropertyValue(element, builder, "socket-buffer-size");
        ParsingUtils.setPropertyValue(element, builder, "socket-read-timeout");
        ParsingUtils.setPropertyValue(element, builder, "persistent");
        ParsingUtils.setPropertyValue(element, builder, "parallel");
        ParsingUtils.setPropertyValue(element, builder, "name");
        Element eventFilterElement = DomUtils.getChildElementByTagName((Element)element, (String)"event-filter");
        if (eventFilterElement != null) {
            builder.addPropertyValue("eventFilters", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, eventFilterElement, builder));
        }
        ParsingUtils.parseTransportFilters(element, parserContext, builder);
        if (!StringUtils.hasText((String)element.getAttribute("name")) && element.getParentNode().getNodeName().endsWith("region")) {
            Element region = (Element)element.getParentNode();
            String regionName = StringUtils.hasText((String)region.getAttribute("name")) ? region.getAttribute("name") : region.getAttribute("id");
            int i = 0;
            String name = regionName + ".gatewaySender#" + i;
            while (parserContext.getRegistry().isBeanNameInUse(name)) {
                name = regionName + ".gatewaySender#" + ++i;
            }
            builder.addPropertyValue("name", (Object)name);
        }
    }
}

