/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import java.util.concurrent.ConcurrentMap;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.util.Assert;

public class PartitionedRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        if (dataPolicy != null) {
            DataPolicy dp = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)dp, (String)("Data policy " + dataPolicy + " is invalid"));
            Assert.isTrue((boolean)dp.withPartitioning(), (String)("Data Policy " + dp.toString() + " is not supported in partitioned regions"));
            if (!this.isPersistent()) {
                regionFactory.setDataPolicy(dp);
                return;
            } else {
                Assert.isTrue((boolean)dp.withPersistence(), (String)("Data Policy " + dp.toString() + "is invalid when persistent is false"));
                regionFactory.setDataPolicy(dp);
            }
            return;
        }
        if (this.isPersistent()) {
            if (!ConcurrentMap.class.isAssignableFrom(Region.class)) throw new IllegalArgumentException("Can define persistent partitions only from GemFire 6.5 onwards - current version is [" + CacheFactory.getVersion() + "]");
            regionFactory.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
            return;
        } else {
            regionFactory.setDataPolicy(DataPolicy.PARTITION);
        }
    }
}

