/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GatewaySenderFactoryBean
extends AbstractWANComponentFactoryBean<GatewaySender> {
    private static List<String> validOrderPolicyValues = Arrays.asList("KEY", "PARTITION", "THREAD");
    private GatewaySender gatewaySender;
    private int remoteDistributedSystemId;
    private List<GatewayEventFilter> eventFilters;
    private List<GatewayTransportFilter> transportFilters;
    private Integer alertThreshold;
    private Boolean enableBatchConflation;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private String diskStoreRef;
    private Boolean diskSynchronous;
    private Integer dispatcherThreads;
    private Boolean manualStart;
    private Integer maximumQueueMemory;
    private String orderPolicy;
    private Boolean parallel;
    private Boolean persistent;
    private Integer socketBufferSize;
    private Integer socketReadTimeout;

    public GatewaySenderFactoryBean(Cache cache) {
        super(cache);
    }

    @Override
    public GatewaySender getObject() throws Exception {
        return this.gatewaySender;
    }

    @Override
    public Class<?> getObjectType() {
        return GatewaySender.class;
    }

    @Override
    protected void doInit() {
        GatewaySenderFactory gatewaySenderFactory = null;
        gatewaySenderFactory = this.factory == null ? this.cache.createGatewaySenderFactory() : (GatewaySenderFactory)this.factory;
        if (this.diskStoreRef != null) {
            this.persistent = this.persistent == null ? Boolean.TRUE : this.persistent;
            Assert.isTrue((boolean)this.persistent, (String)"specifying a disk store requires persistent property to be true");
            gatewaySenderFactory.setDiskStoreName(this.diskStoreRef);
        }
        if (this.diskSynchronous != null) {
            this.persistent = this.persistent == null ? Boolean.TRUE : this.persistent;
            Assert.isTrue((boolean)this.persistent, (String)"specifying a disk synchronous requires persistent property to be true");
            gatewaySenderFactory.setDiskSynchronous(this.diskSynchronous.booleanValue());
        }
        if (this.persistent != null) {
            gatewaySenderFactory.setPersistenceEnabled(this.persistent.booleanValue());
        }
        this.parallel = this.parallel == null ? Boolean.FALSE : this.parallel;
        gatewaySenderFactory.setParallel(this.parallel.booleanValue());
        if (this.orderPolicy != null) {
            Assert.isTrue((boolean)this.parallel, (String)"specifying an order policy requires the parallel property to be true");
            Assert.isTrue((boolean)validOrderPolicyValues.contains(this.orderPolicy.toUpperCase()), (String)("The value of order policy:'" + this.orderPolicy + "' is invalid"));
            gatewaySenderFactory.setOrderPolicy(Gateway.OrderPolicy.valueOf((String)this.orderPolicy.toUpperCase()));
        }
        if (!CollectionUtils.isEmpty(this.eventFilters)) {
            for (GatewayEventFilter eventFilter : this.eventFilters) {
                gatewaySenderFactory.addGatewayEventFilter(eventFilter);
            }
        }
        if (!CollectionUtils.isEmpty(this.transportFilters)) {
            for (GatewayTransportFilter transportFilter : this.transportFilters) {
                gatewaySenderFactory.addGatewayTransportFilter(transportFilter);
            }
        }
        if (this.alertThreshold != null) {
            gatewaySenderFactory.setAlertThreshold(this.alertThreshold.intValue());
        }
        if (this.enableBatchConflation != null) {
            gatewaySenderFactory.setBatchConflationEnabled(this.enableBatchConflation.booleanValue());
        }
        if (this.batchSize != null) {
            gatewaySenderFactory.setBatchSize(this.batchSize.intValue());
        }
        if (this.batchTimeInterval != null) {
            gatewaySenderFactory.setBatchTimeInterval(this.batchTimeInterval.intValue());
        }
        if (this.dispatcherThreads != null) {
            gatewaySenderFactory.setDispatcherThreads(this.dispatcherThreads.intValue());
        }
        if (this.manualStart != null) {
            gatewaySenderFactory.setManualStart(this.manualStart.booleanValue());
        }
        if (this.maximumQueueMemory != null) {
            gatewaySenderFactory.setMaximumQueueMemory(this.maximumQueueMemory.intValue());
        }
        if (this.socketBufferSize != null) {
            gatewaySenderFactory.setSocketBufferSize(this.socketBufferSize.intValue());
        }
        if (this.socketReadTimeout != null) {
            gatewaySenderFactory.setSocketReadTimeout(this.socketReadTimeout.intValue());
        }
        this.gatewaySender = gatewaySenderFactory.create(this.name, this.remoteDistributedSystemId);
    }

    public void setRemoteDistributedSystemId(int remoteDistributedSystemId) {
        this.remoteDistributedSystemId = remoteDistributedSystemId;
    }

    public void setEventFilters(List<GatewayEventFilter> gatewayEventFilters) {
        this.eventFilters = gatewayEventFilters;
    }

    public void setTransportFilters(List<GatewayTransportFilter> gatewayTransportFilters) {
        this.transportFilters = gatewayTransportFilters;
    }

    public void setAlertThreshold(Integer alertThreshold) {
        this.alertThreshold = alertThreshold;
    }

    public void setEnableBatchConflation(Boolean enableBatchConflation) {
        this.enableBatchConflation = enableBatchConflation;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchTimeInterval(Integer batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    public void setDiskStoreRef(String diskStoreRef) {
        this.diskStoreRef = diskStoreRef;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public void setDispatcherThreads(Integer dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = manualStart;
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    public void setOrderPolicy(String orderPolicy) {
        this.orderPolicy = orderPolicy;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setSocketReadTimeout(Integer socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }
}

