/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;

public class AsyncEventQueueFactoryBean
extends AbstractWANComponentFactoryBean<AsyncEventQueue> {
    private final AsyncEventListener asyncEventListener;
    private AsyncEventQueue asyncEventQueue;
    private Integer batchSize;
    private Integer maximumQueueMemory;
    private Boolean persistent;
    private String diskStoreRef;

    public void setDiskStoreRef(String diskStoreRef) {
        this.diskStoreRef = diskStoreRef;
    }

    public AsyncEventQueueFactoryBean(Cache cache, AsyncEventListener asyncEventListener) {
        super(cache);
        this.asyncEventListener = asyncEventListener;
    }

    @Override
    public AsyncEventQueue getObject() throws Exception {
        return this.asyncEventQueue;
    }

    @Override
    public Class<?> getObjectType() {
        return AsyncEventQueue.class;
    }

    @Override
    protected void doInit() {
        Assert.notNull((Object)this.asyncEventListener, (String)"AsyncEventListener cannot be null");
        AsyncEventQueueFactory asyncEventQueueFactory = null;
        asyncEventQueueFactory = this.factory == null ? this.cache.createAsyncEventQueueFactory() : (AsyncEventQueueFactory)this.factory;
        if (this.persistent != null) {
            asyncEventQueueFactory.setPersistent(this.persistent.booleanValue());
        }
        if (this.batchSize != null) {
            asyncEventQueueFactory.setBatchSize(this.batchSize.intValue());
        }
        if (this.diskStoreRef != null) {
            this.persistent = this.persistent == null ? Boolean.TRUE : this.persistent;
            Assert.isTrue((boolean)this.persistent, (String)"specifying a disk store requires persistent property to be true");
            asyncEventQueueFactory.setDiskStoreName(this.diskStoreRef);
        }
        if (this.maximumQueueMemory != null) {
            asyncEventQueueFactory.setMaximumQueueMemory(this.maximumQueueMemory.intValue());
        }
        this.asyncEventQueue = asyncEventQueueFactory.create(this.name, this.asyncEventListener);
    }

    @Override
    public void destroy() throws Exception {
        if (!this.cache.isClosed()) {
            try {
                this.asyncEventListener.close();
            }
            catch (CacheClosedException cacheClosedException) {
                // empty catch block
            }
        }
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }
}

