/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class GemfireRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String MAPPING_CONTEXT_REF = "mapping-context-ref";

    public String getRepositoryFactoryClassName() {
        return GemfireRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "gemfire";
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        String mappingContextRef = element.getAttribute(MAPPING_CONTEXT_REF);
        if (StringUtils.hasText((String)mappingContextRef)) {
            builder.addPropertyReference("mappingContext", mappingContextRef);
        }
    }
}

