/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.AsyncEventQueueParser;
import org.springframework.data.gemfire.config.CacheParser;
import org.springframework.data.gemfire.config.CacheServerParser;
import org.springframework.data.gemfire.config.ClientCacheParser;
import org.springframework.data.gemfire.config.ClientRegionParser;
import org.springframework.data.gemfire.config.DiskStoreParser;
import org.springframework.data.gemfire.config.FunctionServiceParser;
import org.springframework.data.gemfire.config.GatewayHubParser;
import org.springframework.data.gemfire.config.GatewayReceiverParser;
import org.springframework.data.gemfire.config.GatewaySenderParser;
import org.springframework.data.gemfire.config.GemfireListenerContainerParser;
import org.springframework.data.gemfire.config.IndexParser;
import org.springframework.data.gemfire.config.LocalRegionParser;
import org.springframework.data.gemfire.config.LookupRegionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.config.PartitionedRegionParser;
import org.springframework.data.gemfire.config.PoolParser;
import org.springframework.data.gemfire.config.ReplicatedRegionParser;
import org.springframework.data.gemfire.config.TransactionManagerParser;
import org.w3c.dom.Element;

class GemfireNamespaceHandler
extends NamespaceHandlerSupport {
    static final List<String> GEMFIRE7_ELEMENTS = Arrays.asList("async-event-queue", "gateway-sender", "gateway-receiver");

    GemfireNamespaceHandler() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean v7ElementsPresent = GEMFIRE7_ELEMENTS.contains(element.getLocalName());
        if (v7ElementsPresent) {
            ParsingUtils.throwExceptionIfNotGemfireV7(element.getLocalName(), null, parserContext);
        }
        return super.parse(element, parserContext);
    }

    public void init() {
        this.registerBeanDefinitionParser("cache", (BeanDefinitionParser)new CacheParser());
        this.registerBeanDefinitionParser("client-cache", (BeanDefinitionParser)new ClientCacheParser());
        this.registerBeanDefinitionParser("lookup-region", (BeanDefinitionParser)new LookupRegionParser());
        this.registerBeanDefinitionParser("replicated-region", (BeanDefinitionParser)new ReplicatedRegionParser());
        this.registerBeanDefinitionParser("partitioned-region", (BeanDefinitionParser)new PartitionedRegionParser());
        this.registerBeanDefinitionParser("local-region", (BeanDefinitionParser)new LocalRegionParser());
        this.registerBeanDefinitionParser("client-region", (BeanDefinitionParser)new ClientRegionParser());
        this.registerBeanDefinitionParser("pool", (BeanDefinitionParser)new PoolParser());
        this.registerBeanDefinitionParser("index", (BeanDefinitionParser)new IndexParser());
        this.registerBeanDefinitionParser("disk-store", (BeanDefinitionParser)new DiskStoreParser());
        this.registerBeanDefinitionParser("cache-server", (BeanDefinitionParser)new CacheServerParser());
        this.registerBeanDefinitionParser("transaction-manager", (BeanDefinitionParser)new TransactionManagerParser());
        this.registerBeanDefinitionParser("cq-listener-container", (BeanDefinitionParser)new GemfireListenerContainerParser());
        this.registerBeanDefinitionParser("async-event-queue", (BeanDefinitionParser)new AsyncEventQueueParser());
        this.registerBeanDefinitionParser("gateway-sender", (BeanDefinitionParser)new GatewaySenderParser());
        this.registerBeanDefinitionParser("gateway-receiver", (BeanDefinitionParser)new GatewayReceiverParser());
        this.registerBeanDefinitionParser("function-service", (BeanDefinitionParser)new FunctionServiceParser());
        this.registerBeanDefinitionParser("gateway-hub", (BeanDefinitionParser)new GatewayHubParser());
    }
}

