/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.internal.lang.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.wan.AsyncEventQueueFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AsyncEventQueueParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return AsyncEventQueueFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setLazyInit(false);
        Element asyncEventListenerElement = DomUtils.getChildElementByTagName((Element)element, (String)"async-event-listener");
        Object asyncEventListener = ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, asyncEventListenerElement, builder);
        String cacheName = StringUtils.isEmpty((String)element.getAttribute("cache-ref")) ? "gemfireCache" : element.getAttribute("cache-ref");
        builder.addConstructorArgReference(cacheName);
        builder.addConstructorArgValue(asyncEventListener);
        ParsingUtils.setPropertyValue(element, builder, "batch-size");
        ParsingUtils.setPropertyValue(element, builder, "maximum-queue-memory");
        ParsingUtils.setPropertyValue(element, builder, "disk-store-ref");
        ParsingUtils.setPropertyValue(element, builder, "persistent");
        ParsingUtils.setPropertyValue(element, builder, "parallel");
    }
}

