/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.AliasReplacingBeanDefinitionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class AbstractRegionParser
extends AliasReplacingBeanDefinitionParser {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    AbstractRegionParser() {
    }

    @Override
    protected void doParseInternal(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        boolean subRegion = this.isSubRegion(element);
        this.doParseRegion(element, parserContext, builder, subRegion);
        if (subRegion) {
            builder.addPropertyValue("parent", parserContext.getContainingBeanDefinition().getAttribute("parent"));
            builder.addPropertyValue("regionName", (Object)element.getAttribute("name"));
        }
    }

    protected abstract void doParseRegion(Element var1, ParserContext var2, BeanDefinitionBuilder var3, boolean var4);

    protected void doParseSubRegion(Element element, Element subElement, ParserContext parserContext, BeanDefinitionBuilder builder, boolean subRegion) {
        String regionPath = null;
        String parentBeanName = null;
        parentBeanName = subRegion ? parserContext.getContainingBeanDefinition().getAttribute("regionPath").toString() : this.getRegionNameFromElement(element);
        regionPath = StringUtils.arrayToDelimitedString((Object[])new String[]{parentBeanName, this.getRegionNameFromElement(subElement)}, (String)"/");
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        builder.getBeanDefinition().setAttribute("parent", (Object)new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), parentBeanName));
        builder.getBeanDefinition().setAttribute("regionPath", (Object)regionPath);
        BeanDefinition subRegionDef = this.parseSubRegion(subElement, parserContext, builder);
        subRegionDef.setScope("prototype");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("registering subregion as " + regionPath));
        }
        this.registerBeanDefinition(new BeanDefinitionHolder(subRegionDef, regionPath), parserContext.getRegistry());
    }

    protected void doParseCommonRegionConfiguration(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, BeanDefinitionBuilder attrBuilder, boolean subRegion) {
        if (!subRegion) {
            String cacheRef = element.getAttribute("cache-ref");
            builder.addPropertyReference("cache", StringUtils.hasText((String)cacheRef) ? cacheRef : "gemfireCache");
        }
        ParsingUtils.setPropertyValue(element, builder, "name");
        ParsingUtils.parseOptionalRegionAttributes(parserContext, element, attrBuilder);
        ParsingUtils.parseStatistics(element, attrBuilder);
        ParsingUtils.setPropertyValue(element, attrBuilder, "publisher");
        if (!this.isSubRegion(element)) {
            ParsingUtils.setPropertyValue(element, builder, "persistent");
        }
        ParsingUtils.setPropertyValue(element, builder, "data-policy");
        if (StringUtils.hasText((String)element.getAttribute("disk-store-ref"))) {
            ParsingUtils.setPropertyValue(element, builder, "disk-store-ref", "diskStoreName");
            builder.addDependsOn(element.getAttribute("disk-store-ref"));
        }
        ParsingUtils.parseExpiration(parserContext, element, attrBuilder);
        ParsingUtils.parseEviction(parserContext, element, attrBuilder);
        ParsingUtils.parseMembershipAttributes(parserContext, element, attrBuilder);
        String enableGateway = element.getAttribute("enable-gateway");
        String hubId = element.getAttribute("hub-id");
        if (StringUtils.hasText((String)enableGateway) && ParsingUtils.isGemfireV7OrAbove()) {
            this.log.warn((Object)"'enable-gateway' is deprecated since Gemfire 7.0");
        }
        ParsingUtils.setPropertyValue(element, builder, "enable-gateway");
        if (StringUtils.hasText((String)hubId)) {
            if (ParsingUtils.isGemfireV7OrAbove()) {
                this.log.warn((Object)"'hub-id' is deprecated since Gemfire 7.0");
            }
            if (!CollectionUtils.isEmpty((Collection)DomUtils.getChildElementsByTagName((Element)element, (String)"gateway-sender"))) {
                parserContext.getReaderContext().error("It is invalid to specify both 'hub-id' and 'gateway-sender'", (Object)element);
            }
        }
        ParsingUtils.setPropertyValue(element, builder, "hub-id");
        this.parseCollectionOfCustomSubElements(parserContext, element, builder, "com.gemstone.gemfire.cache.wan.GatewaySender", "gateway-sender", "gatewaySenders");
        this.parseCollectionOfCustomSubElements(parserContext, element, builder, "com.gemstone.gemfire.cache.wan.AsyncEventQueue", "async-event-queue", "asyncEventQueues");
        List subElements = DomUtils.getChildElements((Element)element);
        for (Element subElement : subElements) {
            if (subElement.getLocalName().equals("cache-listener")) {
                builder.addPropertyValue("cacheListeners", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
                continue;
            }
            if (subElement.getLocalName().equals("cache-loader")) {
                builder.addPropertyValue("cacheLoader", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
                continue;
            }
            if (subElement.getLocalName().equals("cache-writer")) {
                builder.addPropertyValue("cacheWriter", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
                continue;
            }
            if (!subElement.getLocalName().endsWith("region")) continue;
            this.doParseSubRegion(element, subElement, parserContext, builder, subRegion);
        }
    }

    private void parseCollectionOfCustomSubElements(ParserContext parserContext, Element element, BeanDefinitionBuilder builder, String className, String subElementName, String propertyName) {
        List subElements = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{subElementName, subElementName + "-ref"});
        if (!CollectionUtils.isEmpty((Collection)subElements)) {
            ManagedArray array = new ManagedArray(className, subElements.size());
            for (Element subElement : subElements) {
                array.add(ParsingUtils.parseRefOrNestedCustomElement(parserContext, subElement, builder));
            }
            builder.addPropertyValue(propertyName, (Object)array);
        }
    }

    private BeanDefinition parseSubRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(element, (BeanDefinition)builder.getBeanDefinition());
        return beanDefinition;
    }

    private String getRegionNameFromElement(Element element) {
        String name = element.getAttribute("name");
        return StringUtils.hasText((String)name) ? name : element.getAttribute("id");
    }
}

