/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Properties;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClientCacheFactoryBean
extends CacheFactoryBean {
    private String poolName;
    private Pool pool;

    protected GemFireCache createCache(Object factory) {
        ClientCacheFactory ccf = (ClientCacheFactory)factory;
        this.initializePool(ccf);
        return ccf.create();
    }

    protected Object createFactory(Properties props) {
        return new ClientCacheFactory(props);
    }

    protected GemFireCache fetchCache() {
        return ClientCacheFactory.getAnyInstance();
    }

    private void initializePool(ClientCacheFactory ccf) {
        Pool p = this.pool;
        if (p == null && StringUtils.hasText((String)this.poolName)) {
            p = PoolManager.find((String)this.poolName);
            if (p == null) {
                Properties prop = this.mergeProperties();
                prop.setProperty("mcast-port", "0");
                prop.setProperty("locators", "");
                DistributedSystem system = DistributedSystem.connect((Properties)prop);
            }
            Assert.isTrue((boolean)this.getBeanFactory().isTypeMatch(this.poolName, Pool.class), (String)("No bean named " + this.poolName + " of type " + Pool.class.getName() + " found"));
            p = (Pool)this.getBeanFactory().getBean(this.poolName, Pool.class);
            Assert.notNull((Object)p, (String)("No pool named [" + this.poolName + "] found"));
        }
        if (p != null) {
            ccf.setPoolFreeConnectionTimeout(p.getFreeConnectionTimeout());
            ccf.setPoolIdleTimeout(p.getIdleTimeout());
            ccf.setPoolLoadConditioningInterval(p.getLoadConditioningInterval());
            ccf.setPoolMaxConnections(p.getMaxConnections());
            ccf.setPoolMinConnections(p.getMinConnections());
            ccf.setPoolMultiuserAuthentication(p.getMultiuserAuthentication());
            ccf.setPoolPingInterval(p.getPingInterval());
            ccf.setPoolPRSingleHopEnabled(p.getPRSingleHopEnabled());
            ccf.setPoolReadTimeout(p.getReadTimeout());
            ccf.setPoolRetryAttempts(p.getRetryAttempts());
            ccf.setPoolServerGroup(p.getServerGroup());
            ccf.setPoolSocketBufferSize(p.getSocketBufferSize());
            ccf.setPoolStatisticInterval(p.getStatisticInterval());
            ccf.setPoolSubscriptionAckInterval(p.getSubscriptionAckInterval());
            ccf.setPoolSubscriptionEnabled(p.getSubscriptionEnabled());
            ccf.setPoolSubscriptionMessageTrackingTimeout(p.getSubscriptionMessageTrackingTimeout());
            ccf.setPoolSubscriptionRedundancy(p.getSubscriptionRedundancy());
            ccf.setPoolThreadLocalConnections(p.getThreadLocalConnections());
            List locators = p.getLocators();
            if (locators != null) {
                for (InetSocketAddress inet : locators) {
                    ccf.addPoolLocator(inet.getHostName(), inet.getPort());
                }
            }
            List servers = p.getServers();
            if (locators != null) {
                for (InetSocketAddress inet : servers) {
                    ccf.addPoolServer(inet.getHostName(), inet.getPort());
                }
            }
        }
    }

    public void setPoolName(String poolName) {
        Assert.hasText((String)poolName, (String)"pool name is required");
        this.poolName = poolName;
    }

    public void setPool(Pool pool) {
        Assert.notNull((Object)pool, (String)"pool cannot be null");
        this.pool = pool;
    }

    protected void applyPdxOptions(Object factory) {
        if (factory instanceof ClientCacheFactory) {
            new PdxOptions((ClientCacheFactory)factory).run();
        }
    }

    private class PdxOptions
    implements Runnable {
        private ClientCacheFactory factory;

        PdxOptions(ClientCacheFactory factory) {
            this.factory = factory;
        }

        public void run() {
            if (ClientCacheFactoryBean.this.pdxSerializer != null) {
                Assert.isAssignable(PdxSerializer.class, ClientCacheFactoryBean.this.pdxSerializer.getClass(), (String)"Invalid pdx serializer used");
                this.factory.setPdxSerializer((PdxSerializer)ClientCacheFactoryBean.this.pdxSerializer);
            }
            if (ClientCacheFactoryBean.this.pdxDiskStoreName != null) {
                this.factory.setPdxDiskStore(ClientCacheFactoryBean.this.pdxDiskStoreName);
            }
            if (ClientCacheFactoryBean.this.pdxIgnoreUnreadFields != null) {
                this.factory.setPdxIgnoreUnreadFields(ClientCacheFactoryBean.this.pdxIgnoreUnreadFields.booleanValue());
            }
            if (ClientCacheFactoryBean.this.pdxPersistent != null) {
                this.factory.setPdxPersistent(ClientCacheFactoryBean.this.pdxPersistent.booleanValue());
            }
            if (ClientCacheFactoryBean.this.pdxReadSerialized != null) {
                this.factory.setPdxReadSerialized(ClientCacheFactoryBean.this.pdxReadSerialized.booleanValue());
            }
        }
    }
}

