/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.Region;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;
import org.springframework.data.gemfire.support.GemfireCache;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemfireCacheManager
extends AbstractCacheManager {
    private com.gemstone.gemfire.cache.Cache gemfireCache;

    protected Collection<Cache> loadCaches() {
        Assert.notNull((Object)this.gemfireCache, (String)"a backing GemFire cache is required");
        Assert.isTrue((!this.gemfireCache.isClosed() ? 1 : 0) != 0, (String)"the GemFire cache is closed; an open instance is required");
        Set regions = this.gemfireCache.rootRegions();
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>(regions.size());
        for (Region region : regions) {
            caches.add(new GemfireCache(region));
        }
        return caches;
    }

    public Cache getCache(String name) {
        Region reg;
        Cache cache = super.getCache(name);
        if (cache == null && (reg = this.gemfireCache.getRegion(name)) != null) {
            cache = new GemfireCache(reg);
            this.addCache(cache);
        }
        return cache;
    }

    public void setCache(com.gemstone.gemfire.cache.Cache gemfireCache) {
        this.gemfireCache = gemfireCache;
    }
}

